/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import net.solarnetwork.service.Identifiable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;

public interface ExpressionService
extends Identifiable {
    @Override
    public String getUid();

    public URI getLanguageReferenceLink();

    public static URI getGeneralExpressionReferenceLink() {
        String result = "https://github.com/SolarNetwork/solarnetwork/wiki/Expression-Languages";
        Properties props = new Properties();
        try (InputStream in2 = ExpressionService.class.getResourceAsStream("ExpressionService.properties");){
            if (in2 != null) {
                props.load(in2);
                if (props.containsKey("help.url")) {
                    result = props.getProperty("help.url");
                }
            }
        }
        catch (IOException in2) {
            // empty catch block
        }
        URI uri = null;
        if (result != null) {
            try {
                uri = new URI(result);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    public EvaluationContext createEvaluationContext(EvaluationConfiguration var1, Object var2);

    public Expression parseExpression(String var1);

    public <T> T evaluateExpression(Expression var1, Map<String, Object> var2, Object var3, EvaluationContext var4, Class<T> var5);

    public <T> T evaluateExpression(String var1, Map<String, Object> var2, Object var3, EvaluationContext var4, Class<T> var5);

    public static interface EvaluationConfiguration {
        public Map<String, Object> getOptions();
    }
}

