/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.SettingUtils;
import net.solarnetwork.util.ClassUtils;
import net.solarnetwork.util.StringUtils;

public interface IdentifiableConfiguration {
    public String getName();

    public String getServiceIdentifier();

    public Map<String, ?> getServiceProperties();

    public static <T extends IdentifiableConfiguration> List<T> maskConfigurations(List<T> configurations, ConcurrentMap<String, List<SettingSpecifier>> serviceSettings, Function<Void, Iterable<? extends SettingSpecifierProvider>> settingProviderFunction) {
        if (configurations == null || configurations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IdentifiableConfiguration> result = new ArrayList<IdentifiableConfiguration>(configurations.size());
        for (IdentifiableConfiguration config : configurations) {
            IdentifiableConfiguration maskedConfig = IdentifiableConfiguration.maskConfiguration(config, serviceSettings, settingProviderFunction);
            if (maskedConfig == null) continue;
            result.add(maskedConfig);
        }
        return result;
    }

    public static <T extends IdentifiableConfiguration> T maskConfiguration(T config, ConcurrentMap<String, List<SettingSpecifier>> serviceSettings, Function<Void, Iterable<? extends SettingSpecifierProvider>> settingProviderFunction) {
        Map<String, ?> serviceProps;
        Map<String, ?> maskedServiceProps;
        String id = config.getServiceIdentifier();
        if (id == null) {
            return null;
        }
        List<SettingSpecifier> settings = (List<SettingSpecifier>)serviceSettings.get(id);
        if (settings == null && (settings = SettingSpecifierProvider.settingsForService(id, settingProviderFunction.apply(null))) != null) {
            serviceSettings.put(id, settings);
        }
        if (settings != null && (maskedServiceProps = StringUtils.sha256MaskedMap(serviceProps = config.getServiceProperties(), SettingUtils.secureKeys(settings))) != null) {
            ClassUtils.setBeanProperties(config, Collections.singletonMap("serviceProps", maskedServiceProps), true);
        }
        return config;
    }
}

