/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service;

import java.util.Map;
import net.solarnetwork.service.FilterableService;
import net.solarnetwork.service.OptionalServiceNotAvailableException;

public interface OptionalService<T> {
    public T service();

    public static <T> T service(OptionalService<T> optional) {
        return OptionalService.service(optional, null);
    }

    public static <T> T service(OptionalService<T> optional, T fallback) {
        T service = optional != null ? (T)optional.service() : null;
        return service != null ? service : (T)fallback;
    }

    public static <T> T requiredService(OptionalService<T> optional) {
        return OptionalService.requiredService(optional, null);
    }

    public static <T> T requiredService(OptionalService<T> optional, String description) {
        FilterableService f;
        Map<String, ?> filters;
        T service = null;
        Exception t = null;
        try {
            service = OptionalService.service(optional);
            if (service != null) {
                return service;
            }
        }
        catch (Exception e) {
            t = e;
        }
        StringBuilder msg = new StringBuilder("Service");
        if (description != null) {
            msg.append(" [").append(description).append(']');
        }
        if (optional instanceof FilterableService && (filters = (f = (FilterableService)((Object)optional)).getPropertyFilters()) != null && !filters.isEmpty()) {
            msg.append(" matching filter ").append(filters);
        }
        msg.append(" not");
        if (optional == null) {
            msg.append(" configured");
        } else {
            msg.append(" available");
        }
        msg.append('.');
        throw new OptionalServiceNotAvailableException(msg.toString(), t);
    }

    public static interface OptionalFilterableService<T>
    extends OptionalService<T>,
    FilterableService {
    }
}

