/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service;

import java.time.Duration;
import java.time.Instant;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.util.ObjectUtils;

public class PingTestResultDisplay
extends PingTestResult {
    private final String pingTestId;
    private final String pingTestName;
    private final Instant start;
    private final Instant end;

    public PingTestResultDisplay(PingTest test, PingTest.Result result, Instant start) {
        super(ObjectUtils.requireNonNullArgument(result, "result").isSuccess(), result.getMessage(), result.getProperties());
        this.pingTestId = ObjectUtils.requireNonNullArgument(test, "test").getPingTestId();
        this.pingTestName = test.getPingTestName();
        this.start = ObjectUtils.requireNonNullArgument(start, "start");
        this.end = Instant.now();
    }

    public String getPingTestId() {
        return this.pingTestId;
    }

    public String getPingTestName() {
        return this.pingTestName;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public Duration getDuration() {
        return Duration.between(this.start, this.end);
    }
}

