/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URLConnection;
import java.util.Map;
import net.solarnetwork.io.UrlUtils;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.SSLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientSupport {
    public static final String ACCEPT_TEXT = "text/*";
    public static final String ACCEPT_JSON = "application/json,text/json";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    private int connectionTimeout = 15000;
    private OptionalService<SSLService> sslService = null;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected InputStream getInputStreamFromURLConnection(URLConnection conn) throws IOException {
        return UrlUtils.getInputStreamFromURLConnection(conn);
    }

    protected Reader getUnicodeReaderFromURLConnection(URLConnection conn) throws IOException {
        return UrlUtils.getUnicodeReaderFromURLConnection(conn);
    }

    protected URLConnection getURLConnection(String url, String httpMethod) throws IOException {
        return this.getURLConnection(url, httpMethod, ACCEPT_TEXT);
    }

    protected URLConnection getURLConnection(String url, String httpMethod, String accept) throws IOException {
        return UrlUtils.getURLConnection(url, httpMethod, accept, this.connectionTimeout, this.sslService());
    }

    protected void appendXWWWFormURLEncodedValue(StringBuilder buf, String key, Object value) {
        UrlUtils.appendURLEncodedValue(buf, key, value);
    }

    protected String xWWWFormURLEncoded(Map<String, ?> data) {
        return UrlUtils.urlEncoded(data);
    }

    protected URLConnection postXWWWFormURLEncodedData(String url, String accept, Map<String, ?> data) throws IOException {
        return UrlUtils.postXWWWFormURLEncodedData(url, accept, data, this.connectionTimeout, this.sslService());
    }

    protected String postXWWWFormURLEncodedDataForString(String url, Map<String, ?> data) throws IOException {
        return UrlUtils.postXWWWFormURLEncodedDataForString(url, "text/*,application/json", data, this.connectionTimeout, this.sslService());
    }

    private SSLService sslService() {
        OptionalService<SSLService> s = this.getSslService();
        return s != null ? s.service() : null;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public OptionalService<SSLService> getSslService() {
        return this.sslService;
    }

    public void setSslService(OptionalService<SSLService> sslService) {
        this.sslService = sslService;
    }
}

