/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service.support;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.solarnetwork.util.ByteUtils;
import net.solarnetwork.util.ClassUtils;
import net.solarnetwork.util.StringUtils;

public class TextResourceCache {
    public static final TextResourceCache INSTANCE = new TextResourceCache(new ConcurrentHashMap<String, String>(8, 0.9f, 1));
    private final Map<String, String> cache;

    public TextResourceCache() {
        this(new HashMap<String, String>(8));
    }

    public TextResourceCache(Map<String, String> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("The cache argument must not be null.");
        }
        this.cache = cache;
    }

    public String getResourceAsString(String resourceName, Class<?> clazz) {
        return this.getResourceAsString(resourceName, clazz, null, null);
    }

    public String getResourceAsString(String resourceName, Class<?> clazz, Map<String, ?> templateVariables) {
        return this.getResourceAsString(resourceName, clazz, null, templateVariables);
    }

    public String getResourceAsString(String resourceName, Class<?> clazz, Pattern skip) {
        return this.getResourceAsString(resourceName, clazz, skip, null);
    }

    public String getResourceAsString(String resourceName, Class<?> clazz, Pattern skip, Map<String, ?> templateVariables) {
        String key;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(clazz.getName().getBytes());
            digest.update((byte)46);
            digest.update(resourceName.getBytes());
            if (templateVariables != null) {
                digest.update((byte)63);
                int count = 0;
                for (Map.Entry<String, ?> me : templateVariables.entrySet()) {
                    if (count > 0) {
                        digest.update((byte)38);
                    }
                    digest.update(me.getKey().getBytes());
                    digest.update((byte)61);
                    if (me.getValue() == null) continue;
                    digest.update(me.getValue().toString().getBytes());
                }
            }
            key = ByteUtils.encodeHexString(digest.digest(), 0, digest.getDigestLength(), false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 MessageDigest not available.");
        }
        return this.cache.computeIfAbsent(key, k -> {
            String s = ClassUtils.getResourceAsString(resourceName, clazz, skip);
            if (templateVariables != null) {
                s = StringUtils.expandTemplateString(s, templateVariables);
            }
            return s;
        });
    }
}

