/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BaseSettingSpecifier;

public abstract class BaseKeyedSettingSpecifier<T>
extends BaseSettingSpecifier
implements KeyedSettingSpecifier<T> {
    private String key;
    private T defaultValue;
    private boolean trans;
    private Object[] descriptionArguments;

    public BaseKeyedSettingSpecifier(String key, T defaultValue) {
        this(key, defaultValue, false);
    }

    public BaseKeyedSettingSpecifier(String key, T defaultValue, boolean trans) {
        this.setKey(key);
        this.setDefaultValue(defaultValue);
        this.setTransient(trans);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isTransient() {
        return this.trans;
    }

    @Override
    public SettingSpecifier mappedTo(String prefix) {
        return this.mappedWithPlaceholer(prefix + "%s");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("{key=");
        builder.append(this.key);
        builder.append("}");
        return builder.toString();
    }

    public void setTransient(boolean value) {
        this.trans = value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDescriptionArguments(Object[] descriptionArguments) {
        this.descriptionArguments = descriptionArguments;
    }

    @Override
    public Object[] getDescriptionArguments() {
        return this.descriptionArguments;
    }
}

