/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.solarnetwork.domain.LocalizedServiceInfo;
import net.solarnetwork.service.support.BaseLocalizedServiceInfoProvider;
import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.BasicConfigurableLocalizedServiceInfo;
import org.springframework.context.MessageSource;

public abstract class BaseSettingsSpecifierLocalizedServiceInfoProvider<PK extends Comparable<PK>>
extends BaseLocalizedServiceInfoProvider<PK>
implements SettingSpecifierProvider {
    public BaseSettingsSpecifierLocalizedServiceInfoProvider(PK id) {
        super(id);
    }

    @Override
    public String getSettingUid() {
        Object id = this.getId();
        return id != null ? id.toString() : null;
    }

    @Override
    public LocalizedServiceInfo getLocalizedServiceInfo(Locale locale) {
        return new BasicConfigurableLocalizedServiceInfo(super.getLocalizedServiceInfo(locale), this.getSettingSpecifiers());
    }

    @Override
    protected Map<String, String> resolveInfoMessages(Locale locale) {
        List<SettingSpecifier> specs = this.getSettingSpecifiers();
        MessageSource ms = this.getMessageSource();
        if (specs == null || specs.isEmpty() || ms == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> msgs = new LinkedHashMap<String, String>(specs.size() * 2);
        for (SettingSpecifier spec : specs) {
            this.populateInfoMessages(locale, spec, msgs, ms);
        }
        return msgs;
    }

    protected void populateInfoMessages(Locale locale, SettingSpecifier spec, Map<String, String> msgs, MessageSource ms) {
        if (spec instanceof KeyedSettingSpecifier) {
            KeyedSettingSpecifier ks = (KeyedSettingSpecifier)spec;
            String key = ks.getKey();
            String code = key + ".key";
            String value = ms.getMessage(code, null, "", locale);
            msgs.put(code, value);
            code = key + ".desc";
            value = ms.getMessage(code, null, "", locale);
            msgs.put(code, value);
        }
    }
}

