/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SliderSettingSpecifier;
import net.solarnetwork.settings.support.BaseKeyedSettingSpecifier;

public class BasicSliderSettingSpecifier
extends BaseKeyedSettingSpecifier<Double>
implements SliderSettingSpecifier {
    private Double minimumValue = 0.0;
    private Double maximumValue = 1.0;
    private Double step = 1.0;

    public BasicSliderSettingSpecifier(String key, Double defaultValue, Double minValue, Double maxValue, Double step) {
        super(key, defaultValue);
        this.setMaximumValue(maxValue);
        this.setMinimumValue(minValue);
        this.setStep(step);
    }

    @Override
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public Double getStep() {
        return this.step;
    }

    @Override
    public SettingSpecifier mappedWithPlaceholer(String template) {
        BasicSliderSettingSpecifier spec = new BasicSliderSettingSpecifier(String.format(template, this.getKey()), (Double)this.getDefaultValue(), this.minimumValue, this.maximumValue, this.step);
        spec.setTitle(this.getTitle());
        return spec;
    }

    @Override
    public SettingSpecifier mappedWithMapper(MappableSpecifier.Mapper mapper) {
        BasicSliderSettingSpecifier spec = new BasicSliderSettingSpecifier(mapper.mapKey(this.getKey()), (Double)this.getDefaultValue(), this.minimumValue, this.maximumValue, this.step);
        spec.setTitle(this.getTitle());
        return spec;
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public void setStep(Double step) {
        this.step = step;
    }
}

