/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import java.util.Collections;
import java.util.Map;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.TitleSettingSpecifier;
import net.solarnetwork.settings.support.BaseKeyedSettingSpecifier;

public class BasicTitleSettingSpecifier
extends BaseKeyedSettingSpecifier<String>
implements TitleSettingSpecifier {
    private Map<String, String> valueTitles;
    private boolean markup;

    public BasicTitleSettingSpecifier(String key, String defaultValue) {
        super(key, defaultValue);
    }

    public BasicTitleSettingSpecifier(String key, String defaultValue, boolean trans) {
        super(key, defaultValue, trans);
    }

    public BasicTitleSettingSpecifier(String key, String defaultValue, boolean trans, boolean markup) {
        super(key, defaultValue, trans);
        this.markup = markup;
    }

    @Override
    public Map<String, String> getValueTitles() {
        return this.valueTitles;
    }

    @Override
    public boolean isMarkup() {
        return this.markup;
    }

    @Override
    public SettingSpecifier mappedWithPlaceholer(String template) {
        BasicTitleSettingSpecifier spec = new BasicTitleSettingSpecifier(String.format(template, this.getKey()), (String)this.getDefaultValue(), this.isTransient(), this.isMarkup());
        spec.setTitle(this.getTitle());
        spec.setValueTitles(this.valueTitles);
        spec.setDescriptionArguments(this.getDescriptionArguments());
        return spec;
    }

    @Override
    public SettingSpecifier mappedWithMapper(MappableSpecifier.Mapper mapper) {
        BasicTitleSettingSpecifier spec = new BasicTitleSettingSpecifier(mapper.mapKey(this.getKey()), (String)this.getDefaultValue(), this.isTransient(), this.isMarkup());
        spec.setTitle(this.getTitle());
        spec.setValueTitles(this.valueTitles);
        spec.setDescriptionArguments(this.getDescriptionArguments());
        return spec;
    }

    public void setValueTitles(Map<String, String> valueTitles) {
        this.valueTitles = valueTitles == null ? null : Collections.unmodifiableMap(valueTitles);
    }

    public void setMarkup(boolean markup) {
        this.markup = markup;
    }
}

