/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.service.IdentifiableConfiguration;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.TextFieldSettingSpecifier;
import net.solarnetwork.util.StringUtils;
import org.springframework.util.ClassUtils;

public class SecureEntryMaskingIdentifiableConfiguration
implements InvocationHandler {
    private static final String SERVICE_PROPERTIES_KEY_PREFIX = "serviceProperties.";
    private static final String SERVICE_PROPERTIES_GETTER_NAME = "getServiceProperties";
    private final IdentifiableConfiguration delegate;
    private final Set<String> secureSettings;
    private final Set<String> secureServiceProperties;

    public SecureEntryMaskingIdentifiableConfiguration(IdentifiableConfiguration delegate, List<SettingSpecifier> settings) {
        this.delegate = delegate;
        if (settings == null || settings.isEmpty()) {
            this.secureSettings = Collections.emptySet();
            this.secureServiceProperties = Collections.emptySet();
        } else {
            Set secure = null;
            Set secureProps = null;
            for (SettingSpecifier setting : settings) {
                String key;
                TextFieldSettingSpecifier text;
                if (!(setting instanceof TextFieldSettingSpecifier) || !(text = (TextFieldSettingSpecifier)setting).isSecureTextEntry() || (key = text.getKey()) == null || key.isEmpty()) continue;
                if (key.startsWith(SERVICE_PROPERTIES_KEY_PREFIX)) {
                    String propKey = key.substring(SERVICE_PROPERTIES_KEY_PREFIX.length());
                    if (secureProps == null) {
                        secureProps = new HashSet(4);
                    }
                    secureProps.add(propKey);
                    continue;
                }
                key = "get" + key.substring(0, 1).toUpperCase() + (key.length() > 1 ? key.substring(1) : "");
                if (secure == null) {
                    secure = new HashSet(4);
                }
                secure.add(key);
            }
            this.secureSettings = secure != null ? secure : Collections.emptySet();
            this.secureServiceProperties = secureProps != null ? secureProps : Collections.emptySet();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Method delegateMethod = this.delegate.getClass().getMethod(methodName, method.getParameterTypes());
        LinkedHashMap res = delegateMethod.invoke((Object)this.delegate, args);
        if (SERVICE_PROPERTIES_GETTER_NAME.equals(methodName) && !this.secureServiceProperties.isEmpty() && res instanceof Map) {
            Map map = res;
            for (String propName : this.secureServiceProperties) {
                if (!map.containsKey(propName)) continue;
                LinkedHashMap maskedMap = new LinkedHashMap(map.size());
                for (Map.Entry me : map.entrySet()) {
                    String key = me.getKey().toString();
                    Object val = me.getValue();
                    if (val != null && this.secureServiceProperties.contains(key)) {
                        val = StringUtils.sha256Base64Value(val.toString());
                    }
                    maskedMap.put(key, val);
                }
                res = maskedMap;
                break;
            }
        } else if (res != null && this.secureSettings.contains(methodName)) {
            res = StringUtils.sha256Base64Value(((Object)res).toString());
        }
        return res;
    }

    public static IdentifiableConfiguration createProxy(IdentifiableConfiguration configuration, List<SettingSpecifier> settings) {
        Class[] interfaces = ClassUtils.getAllInterfaces((Object)configuration);
        Object proxy = Proxy.newProxyInstance(configuration.getClass().getClassLoader(), interfaces, (InvocationHandler)new SecureEntryMaskingIdentifiableConfiguration(configuration, settings));
        return (IdentifiableConfiguration)proxy;
    }
}

