/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.support;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

public class CloningPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private Map<String, PropertyEditor> propertyEditors = null;
    private Map<Class<?>, PropertyEditor> classEditors = null;
    private boolean lenient = true;

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (this.propertyEditors != null) {
            for (Map.Entry<Object, PropertyEditor> entry : this.propertyEditors.entrySet()) {
                this.registerEditor(registry, entry);
            }
        }
        if (this.classEditors != null) {
            for (Map.Entry<Object, PropertyEditor> entry : this.classEditors.entrySet()) {
                this.registerEditor(registry, entry);
            }
        }
    }

    public void setPropertyEditor(String key, PropertyEditor editor) {
        if (this.propertyEditors == null) {
            this.propertyEditors = new LinkedHashMap<String, PropertyEditor>();
        }
        this.propertyEditors.put(key, editor);
    }

    public void setPropertyEditor(Class<?> clazz, PropertyEditor editor) {
        if (this.classEditors == null) {
            this.classEditors = new LinkedHashMap();
        }
        this.classEditors.put(clazz, editor);
    }

    private void registerEditor(PropertyEditorRegistry registry, Map.Entry<?, PropertyEditor> me) {
        PropertyEditor ed = me.getValue();
        Object key = me.getKey();
        try {
            Method m = ed.getClass().getMethod("clone", null);
            PropertyEditor copy = (PropertyEditor)m.invoke((Object)ed, (Object[])null);
            this.registerValue(registry, copy, key);
        }
        catch (NoSuchMethodException e) {
            if (this.lenient) {
                this.registerValue(registry, ed, key);
            }
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerValue(PropertyEditorRegistry registry, PropertyEditor copy, Object key) {
        if (key instanceof Class) {
            registry.registerCustomEditor((Class)key, null, copy);
        } else {
            registry.registerCustomEditor(null, (String)key, copy);
        }
    }

    public Map<String, PropertyEditor> getPropertyEditors() {
        return this.propertyEditors;
    }

    public void setPropertyEditors(Map<String, PropertyEditor> propertyEditors) {
        this.propertyEditors = propertyEditors;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public Map<Class<?>, PropertyEditor> getClassEditors() {
        return this.classEditors;
    }

    public void setClassEditors(Map<Class<?>, PropertyEditor> classEditors) {
        this.classEditors = classEditors;
    }
}

