/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.support;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class TemplatedMessageSource
implements MessageSource,
HierarchicalMessageSource {
    private String regex;
    private Pattern pat;
    private MessageSource delegate;

    public void setParentMessageSource(MessageSource parent) {
        if (!(this.delegate instanceof HierarchicalMessageSource)) {
            throw new UnsupportedOperationException("Delegate does not implement HierarchicalMessageSource");
        }
        ((HierarchicalMessageSource)this.delegate).setParentMessageSource(parent);
    }

    public MessageSource getParentMessageSource() {
        if (this.delegate instanceof HierarchicalMessageSource) {
            return ((HierarchicalMessageSource)this.delegate).getParentMessageSource();
        }
        throw new UnsupportedOperationException("Delegate does not implement HierarchicalMessageSource");
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        if (this.pat != null) {
            Matcher m = this.pat.matcher(code);
            int count = m.groupCount();
            if (m.matches() && count > 0) {
                StringBuilder buf = new StringBuilder();
                for (int i = 1; i <= count; ++i) {
                    buf.append(m.group(i));
                }
                code = buf.toString();
            }
        }
        return this.delegate.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        if (this.pat != null) {
            Matcher m = this.pat.matcher(code);
            int count = m.groupCount();
            if (m.matches() && count > 0) {
                StringBuilder buf = new StringBuilder();
                for (int i = 1; i <= count; ++i) {
                    buf.append(m.group(i));
                }
                code = buf.toString();
            }
        }
        return this.delegate.getMessage(code, args, locale);
    }

    public String getMessage(final MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        final String[] codes = resolvable.getCodes();
        if (this.pat != null) {
            for (int i = 0; i < codes.length; ++i) {
                Matcher m = this.pat.matcher(codes[i]);
                int count = m.groupCount();
                if (!m.matches() || count <= 0) continue;
                StringBuilder buf = new StringBuilder();
                for (int j = 1; j <= count; ++j) {
                    buf.append(m.group(j));
                }
                codes[i] = buf.toString();
            }
        }
        return this.delegate.getMessage(new MessageSourceResolvable(){

            public String getDefaultMessage() {
                return resolvable.getDefaultMessage();
            }

            public String[] getCodes() {
                return codes;
            }

            public Object[] getArguments() {
                return resolvable.getArguments();
            }
        }, locale);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.pat = regex != null && regex.length() > 0 ? Pattern.compile(regex) : null;
    }

    public MessageSource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(MessageSource delegate) {
        this.delegate = delegate;
    }
}

