/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.support;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSupport {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private NamespaceContext nsContext = null;
    private DocumentBuilderFactory docBuilderFactory = null;
    private XPathFactory xpathFactory = null;
    private TransformerFactory transformerFactory = null;

    public Map<String, XPathExpression> getXPathExpressionMap(Map<String, String> xpathMap) {
        LinkedHashMap<String, XPathExpression> datumXPathMap = new LinkedHashMap<String, XPathExpression>();
        for (Map.Entry<String, String> me : xpathMap.entrySet()) {
            try {
                datumXPathMap.put(me.getKey(), this.getXPathExpression(me.getValue()));
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return datumXPathMap;
    }

    public XPathExpression getXPathExpression(String xpath) throws XPathExpressionException {
        XPath xp = this.getXpathFactory().newXPath();
        if (this.getNsContext() != null) {
            xp.setNamespaceContext(this.getNsContext());
        }
        return xp.compile(xpath);
    }

    public Templates getTemplates(Resource resource) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            return tf.newTemplates(new StreamSource(resource.getInputStream()));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Unable to load XSLT from resource [" + resource + ']');
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load XSLT from resource [" + resource + ']');
        }
    }

    public Document getDocument(BeanWrapper bean, String elementName) {
        Document dom = null;
        try {
            dom = this.getDocBuilderFactory().newDocumentBuilder().newDocument();
            dom.appendChild(this.getElement(bean, elementName, dom));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return dom;
    }

    public Element getElement(BeanWrapper bean, Document dom) {
        String elementName = bean.getWrappedInstance().getClass().getSimpleName();
        return this.getElement(bean, elementName, dom);
    }

    public Element getElement(BeanWrapper bean, String elementName, Document dom) {
        PropertyDescriptor[] props = bean.getPropertyDescriptors();
        Element root = null;
        root = dom.createElement(elementName);
        for (int i = 0; i < props.length; ++i) {
            String propName;
            PropertyDescriptor prop = props[i];
            if (prop.getReadMethod() == null || "class".equals(propName = prop.getName())) continue;
            Object propValue = null;
            PropertyEditor editor = bean.findCustomEditor(prop.getPropertyType(), prop.getName());
            if (editor != null) {
                editor.setValue(bean.getPropertyValue(propName));
                propValue = editor.getAsText();
            } else {
                propValue = bean.getPropertyValue(propName);
            }
            if (propValue == null) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("attribute name: " + propName + " attribute value: " + propValue);
            }
            root.setAttribute(propName, propValue.toString());
        }
        return root;
    }

    public Source getSource(BeanWrapper bean, String elementName) {
        Document dom = this.getDocument(bean, elementName);
        return this.getSource(dom);
    }

    public Source getSource(Document dom) {
        DOMSource result = new DOMSource(dom);
        if (this.log.isDebugEnabled()) {
            this.log.debug("XML: " + this.getXmlAsString(result, true));
        }
        return result;
    }

    public String getXmlAsString(Source source, boolean indent) {
        ByteArrayOutputStream byos = new ByteArrayOutputStream();
        try {
            Transformer xform = this.getTransformerFactory().newTransformer();
            if (indent) {
                xform.setOutputProperty("indent", "yes");
                xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            xform.transform(source, new StreamResult(byos));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return byos.toString();
    }

    public void extractBeanDataFromXml(PropertyAccessor bean, Node xml, Map<String, XPathExpression> xpathMap) {
        for (Map.Entry<String, XPathExpression> me : xpathMap.entrySet()) {
            String val = this.extractStringFromXml(xml, me.getValue());
            if (val == null || "".equals(val)) continue;
            bean.setPropertyValue(me.getKey(), (Object)val);
        }
    }

    public String extractStringFromXml(Node xml, XPathExpression xpath) {
        try {
            return (String)xpath.evaluate(xml, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Unable to extract string from XPath [" + xpath.toString() + "]", e);
        }
    }

    public NamespaceContext getNsContext() {
        return this.nsContext;
    }

    public void setNsContext(NamespaceContext nsContext) {
        this.nsContext = nsContext;
    }

    public DocumentBuilderFactory getDocBuilderFactory() {
        DocumentBuilderFactory result = this.docBuilderFactory;
        if (result == null) {
            result = DocumentBuilderFactory.newInstance();
            result.setNamespaceAware(true);
            this.docBuilderFactory = result;
        }
        return result;
    }

    public void setDocBuilderFactory(DocumentBuilderFactory docBuilderFactory) {
        this.docBuilderFactory = docBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathFactory getXpathFactory() {
        XPathFactory result = this.xpathFactory;
        if (result == null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = XPathFactory.class.getClassLoader();
            if (newClassLoader != null) {
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            try {
                this.xpathFactory = result = XPathFactory.newInstance();
            }
            finally {
                if (newClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
            }
        }
        return result;
    }

    public void setXpathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public TransformerFactory getTransformerFactory() {
        TransformerFactory result = this.transformerFactory;
        if (result == null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(XPathFactory.class.getClassLoader());
            try {
                this.transformerFactory = result = TransformerFactory.newInstance();
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
        return result;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }
}

