/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.springframework.beans.factory.ObjectFactory;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] arrayWithLength(T[] array, int count, Class<T> itemClass, ObjectFactory<? extends T> factory) {
        if (count < 0) {
            count = 0;
        }
        int inCount = array == null ? -1 : array.length;
        Object[] result = array;
        if (inCount != count) {
            Object[] newIncs = (Object[])Array.newInstance(itemClass, count);
            if (array != null) {
                System.arraycopy(array, 0, newIncs, 0, Math.min(count, inCount));
            }
            for (int i = 0; i < count; ++i) {
                if (newIncs[i] != null) continue;
                if (factory != null) {
                    newIncs[i] = factory.getObject();
                    continue;
                }
                try {
                    newIncs[i] = itemClass.newInstance();
                    continue;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            result = newIncs;
        }
        return result;
    }

    public static String[] filterByEnabledDisabled(String[] list, String[] enabled, String[] disabled) {
        String[] finalEnabledProtocols = list;
        if (enabled != null) {
            LinkedHashSet<Pattern> pats = new LinkedHashSet<Pattern>(enabled.length);
            String[] stringArray = enabled;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String proto = stringArray[i];
                pats.add(Pattern.compile(proto, 2));
            }
            finalEnabledProtocols = (String[])Arrays.stream(finalEnabledProtocols).filter(p -> pats.stream().filter(pat -> pat.matcher((CharSequence)p).find()).findAny().isPresent()).toArray(String[]::new);
        }
        if (disabled != null) {
            for (String proto : disabled) {
                Pattern pat = Pattern.compile(proto, 2);
                finalEnabledProtocols = (String[])Arrays.stream(finalEnabledProtocols).filter(p -> !pat.matcher((CharSequence)p).find()).toArray(String[]::new);
            }
        }
        return finalEnabledProtocols;
    }

    public static boolean isOnlyNull(Object[] array) {
        if (array == null || array.length < 1) {
            return true;
        }
        for (Object o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }
}

