/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.StringCharacterIterator;
import net.solarnetwork.domain.BitDataType;
import net.solarnetwork.domain.ByteOrdering;

public final class ByteUtils {
    public static final String UTF8_CHARSET = "UTF-8";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String ASCII_CHARSET = "US-ASCII";
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final String LATIN1_CHARSET = "ISO-8859-1";
    public static final Charset LATIN1 = Charset.forName("ISO-8859-1");
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static char[] encodeHex(byte b, char[] toDigits, char[] dest, int destIndex) {
        dest[destIndex] = toDigits[(0xF0 & b) >>> 4];
        dest[destIndex + 1] = toDigits[0xF & b];
        return dest;
    }

    public static char[] encodeHexUpperCase(byte b, char[] dest, int destIndex) {
        return ByteUtils.encodeHex(b, DIGITS_UPPER, dest, destIndex);
    }

    public static char[] encodeHexLowerCase(byte b, char[] dest, int destIndex) {
        return ByteUtils.encodeHex(b, DIGITS_LOWER, dest, destIndex);
    }

    public static String encodeHexString(byte[] data, int fromIndex, int toIndex, boolean space) {
        return ByteUtils.encodeHexString(data, fromIndex, toIndex, space, false);
    }

    public static String encodeHexString(byte[] data, int fromIndex, int toIndex, boolean space, boolean lowerCase) {
        if (data == null || data.length < 1 || fromIndex < 0 || fromIndex >= data.length || toIndex < 0 || toIndex <= fromIndex) {
            return "";
        }
        char[] digits = lowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        StringBuilder hexData = new StringBuilder(2 * (toIndex - fromIndex) + (space ? toIndex - fromIndex : 0));
        char[] buffer = new char[2];
        for (int i = fromIndex; i < toIndex; ++i) {
            if (space && i > fromIndex) {
                hexData.append(' ');
            }
            hexData.append(ByteUtils.encodeHex(data[i], digits, buffer, 0));
        }
        return hexData.toString();
    }

    public static byte[] decodeHexString(String s) {
        if (s == null) {
            return new byte[0];
        }
        return ByteUtils.decodeHexPadStart(s.toCharArray());
    }

    public static byte[] decodeHexPadStart(char[] chars) {
        if (chars == null || chars.length < 1) {
            return new byte[0];
        }
        int len = chars.length;
        boolean even = (len & 1) == 0;
        byte[] data = new byte[(even ? len : len + 1) / 2];
        int i = 0;
        int j = 0;
        if (!even) {
            data[i] = (byte)(Character.digit(chars[j], 16) & 0xFF);
            ++i;
            ++j;
        }
        while (j < len) {
            int n = Character.digit(chars[j], 16) << 4;
            n |= Character.digit(chars[++j], 16);
            ++j;
            data[i] = (byte)(n & 0xFF);
            ++i;
        }
        return data;
    }

    public static void encodeInt8(Number n, byte[] dest, int offset) {
        dest[offset] = n != null ? n.byteValue() : (byte)0;
    }

    public static void encodeUnsignedInt8(Number n, byte[] dest, int offset) {
        dest[offset] = n != null ? (byte)(n.shortValue() & 0xFF) : (byte)0;
    }

    public static void encodeInt16(Number n, byte[] dest, int offset, ByteOrdering byteOrder) {
        short s;
        short s2 = s = n != null ? n.shortValue() : (short)0;
        if (byteOrder == ByteOrdering.BigEndian) {
            dest[offset] = (byte)(s >> 8 & 0xFF);
            dest[offset + 1] = (byte)(s & 0xFF);
        } else {
            dest[offset + 1] = (byte)(s >> 8 & 0xFF);
            dest[offset] = (byte)(s & 0xFF);
        }
    }

    public static void encodeUnsignedInt16(Number n, byte[] dest, int offset, ByteOrdering byteOrder) {
        short s;
        short s2 = s = n != null ? n.shortValue() : (short)0;
        if (byteOrder == ByteOrdering.BigEndian) {
            dest[offset] = (byte)(s >>> 8 & 0xFF);
            dest[offset + 1] = (byte)(s & 0xFF);
        } else {
            dest[offset + 1] = (byte)(s >> 8 & 0xFF);
            dest[offset] = (byte)(s & 0xFF);
        }
    }

    public static void encodeInt32(Number n, byte[] dest, int offset, ByteOrdering byteOrder) {
        int s;
        int n2 = s = n != null ? n.intValue() : 0;
        if (byteOrder == ByteOrdering.BigEndian) {
            dest[offset] = (byte)(s >> 24 & 0xFF);
            dest[offset + 1] = (byte)(s >> 16 & 0xFF);
            dest[offset + 2] = (byte)(s >> 8 & 0xFF);
            dest[offset + 3] = (byte)(s & 0xFF);
        } else {
            dest[offset + 3] = (byte)(s >> 24 & 0xFF);
            dest[offset + 2] = (byte)(s >> 16 & 0xFF);
            dest[offset + 1] = (byte)(s >> 8 & 0xFF);
            dest[offset] = (byte)(s & 0xFF);
        }
    }

    public static void encodeUnsignedInt32(Number n, byte[] dest, int offset, ByteOrdering byteOrder) {
        int s;
        int n2 = s = n != null ? n.intValue() : 0;
        if (byteOrder == ByteOrdering.BigEndian) {
            dest[offset] = (byte)(s >>> 24 & 0xFF);
            dest[offset + 1] = (byte)(s >>> 16 & 0xFF);
            dest[offset + 2] = (byte)(s >>> 8 & 0xFF);
            dest[offset + 3] = (byte)(s & 0xFF);
        } else {
            dest[offset + 3] = (byte)(s >>> 24 & 0xFF);
            dest[offset + 2] = (byte)(s >>> 16 & 0xFF);
            dest[offset + 1] = (byte)(s >>> 8 & 0xFF);
            dest[offset] = (byte)(s & 0xFF);
        }
    }

    public static void encodeInt64(Number n, byte[] dest, int offset, ByteOrdering byteOrder) {
        long s = n != null ? n.longValue() : 0L;
        ByteUtils.encodeInt64(s, dest, offset, byteOrder);
    }

    public static void encodeInt64(long l, byte[] dest, int offset, ByteOrdering byteOrder) {
        if (byteOrder == ByteOrdering.BigEndian) {
            dest[offset] = (byte)(l >> 56 & 0xFFL);
            dest[offset + 1] = (byte)(l >> 48 & 0xFFL);
            dest[offset + 2] = (byte)(l >> 40 & 0xFFL);
            dest[offset + 3] = (byte)(l >> 32 & 0xFFL);
            dest[offset + 4] = (byte)(l >> 24 & 0xFFL);
            dest[offset + 5] = (byte)(l >> 16 & 0xFFL);
            dest[offset + 6] = (byte)(l >> 8 & 0xFFL);
            dest[offset + 7] = (byte)(l & 0xFFL);
        } else {
            dest[offset + 7] = (byte)(l >> 56 & 0xFFL);
            dest[offset + 6] = (byte)(l >> 48 & 0xFFL);
            dest[offset + 5] = (byte)(l >> 40 & 0xFFL);
            dest[offset + 4] = (byte)(l >> 32 & 0xFFL);
            dest[offset + 3] = (byte)(l >> 24 & 0xFFL);
            dest[offset + 2] = (byte)(l >> 16 & 0xFFL);
            dest[offset + 1] = (byte)(l >> 8 & 0xFFL);
            dest[offset] = (byte)(l & 0xFFL);
        }
    }

    public static void encodeUnsignedInt64(Number n, byte[] dest, int offset, ByteOrdering byteOrder) {
        long s = n != null ? n.longValue() : 0L;
        ByteUtils.encodeUnsignedInt64(s, dest, offset, byteOrder);
    }

    public static void encodeUnsignedInt64(long l, byte[] dest, int offset, ByteOrdering byteOrder) {
        if (byteOrder == ByteOrdering.BigEndian) {
            dest[offset] = (byte)(l >>> 56 & 0xFFL);
            dest[offset + 1] = (byte)(l >>> 48 & 0xFFL);
            dest[offset + 2] = (byte)(l >>> 40 & 0xFFL);
            dest[offset + 3] = (byte)(l >>> 32 & 0xFFL);
            dest[offset + 4] = (byte)(l >>> 24 & 0xFFL);
            dest[offset + 5] = (byte)(l >>> 16 & 0xFFL);
            dest[offset + 6] = (byte)(l >>> 8 & 0xFFL);
            dest[offset + 7] = (byte)(l & 0xFFL);
        } else {
            dest[offset + 7] = (byte)(l >>> 56 & 0xFFL);
            dest[offset + 6] = (byte)(l >>> 48 & 0xFFL);
            dest[offset + 5] = (byte)(l >>> 40 & 0xFFL);
            dest[offset + 4] = (byte)(l >>> 32 & 0xFFL);
            dest[offset + 3] = (byte)(l >>> 24 & 0xFFL);
            dest[offset + 2] = (byte)(l >>> 16 & 0xFFL);
            dest[offset + 1] = (byte)(l >>> 8 & 0xFFL);
            dest[offset] = (byte)(l & 0xFFL);
        }
    }

    public static Number parseNumber(BitDataType dataType, byte[] data, int offset, ByteOrdering byteOrder) {
        if (dataType.isVariableLength()) {
            throw new IllegalArgumentException("Variable length data types not supported.");
        }
        return ByteUtils.parseNumber(dataType, data, offset, 0, byteOrder);
    }

    public static Number parseNumber(BitDataType dataType, byte[] data, int offset, int length, ByteOrdering byteOrder) {
        Number result = null;
        switch (dataType) {
            case Bit: 
            case Boolean: {
                if (offset >= data.length) break;
                result = data[offset] == 0 ? 0 : 1;
                break;
            }
            case Float32: {
                if (offset + 3 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseFloat32(data[offset], data[offset + 1], data[offset + 2], data[offset + 3]);
                    break;
                }
                result = ByteUtils.parseFloat32(data[offset + 3], data[offset + 2], data[offset + 1], data[offset]);
                break;
            }
            case Float64: {
                if (offset + 7 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseFloat64(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], data[offset + 4], data[offset + 5], data[offset + 6], data[offset + 7]);
                    break;
                }
                result = ByteUtils.parseFloat64(data[offset + 7], data[offset + 6], data[offset + 5], data[offset + 4], data[offset + 3], data[offset + 2], data[offset + 1], data[offset]);
                break;
            }
            case Int8: {
                if (offset >= data.length) break;
                result = ByteUtils.parseInt8(data[offset]);
                break;
            }
            case UInt8: {
                if (offset >= data.length) break;
                result = ByteUtils.parseUnsignedInt8(data[offset]);
                break;
            }
            case Int16: {
                if (offset + 1 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseInt16(data[offset], data[offset + 1]);
                    break;
                }
                result = ByteUtils.parseInt16(data[offset + 1], data[offset]);
                break;
            }
            case UInt16: {
                if (offset + 1 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseUnsignedInt16(data[offset], data[offset + 1]);
                    break;
                }
                result = ByteUtils.parseUnsignedInt16(data[offset + 1], data[offset]);
                break;
            }
            case Int32: {
                if (offset + 3 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseInt32(data[offset], data[offset + 1], data[offset + 2], data[offset + 3]);
                    break;
                }
                result = ByteUtils.parseInt32(data[offset + 3], data[offset + 2], data[offset + 1], data[offset]);
                break;
            }
            case UInt32: {
                if (offset + 3 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseUnsignedInt32(data[offset], data[offset + 1], data[offset + 2], data[offset + 3]);
                    break;
                }
                result = ByteUtils.parseUnsignedInt32(data[offset + 3], data[offset + 2], data[offset + 1], data[offset]);
                break;
            }
            case Int64: {
                if (offset + 7 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseInt64(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], data[offset + 4], data[offset + 5], data[offset + 6], data[offset + 7]);
                    break;
                }
                result = ByteUtils.parseInt64(data[offset + 7], data[offset + 6], data[offset + 5], data[offset + 4], data[offset + 3], data[offset + 2], data[offset + 1], data[offset]);
                break;
            }
            case UInt64: {
                if (offset + 7 >= data.length) break;
                if (byteOrder == ByteOrdering.BigEndian) {
                    result = ByteUtils.parseUnsignedInt64(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], data[offset + 4], data[offset + 5], data[offset + 6], data[offset + 7]);
                    break;
                }
                result = ByteUtils.parseUnsignedInt64(data[offset + 7], data[offset + 6], data[offset + 5], data[offset + 4], data[offset + 3], data[offset + 2], data[offset + 1], data[offset]);
                break;
            }
            case Bytes: 
            case UnsignedInteger: {
                if (offset + length > data.length) break;
                result = ByteUtils.parseUnsignedInteger(data, offset, length, byteOrder);
                break;
            }
            case Integer: {
                if (offset + length > data.length) break;
                result = ByteUtils.parseInteger(data, offset, length, byteOrder);
                break;
            }
            case StringAscii: {
                if (offset + length > data.length) break;
                result = ByteUtils.parseDecimalCharacterString(data, offset, length, byteOrder, ASCII);
                break;
            }
            case StringUtf8: {
                if (offset + length > data.length) break;
                result = ByteUtils.parseDecimalCharacterString(data, offset, length, byteOrder, UTF8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type " + (Object)((Object)dataType) + " cannot be converted into a number.");
            }
        }
        return result;
    }

    public static Byte parseInt8(byte b) {
        return b;
    }

    public static Short parseUnsignedInt8(byte b) {
        return (short)(b & 0xFF);
    }

    public static Short parseInt16(byte hi, byte lo) {
        return (short)((hi & 0xFF) << 8 | lo & 0xFF);
    }

    public static Integer parseUnsignedInt16(byte hi, byte lo) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    public static Integer parseInt32(byte d, byte c, byte b, byte a) {
        return (d & 0xFF) << 24 | (c & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static Long parseUnsignedInt32(byte d, byte c, byte b, byte a) {
        return ((long)d & 0xFFL) << 24 | ((long)c & 0xFFL) << 16 | ((long)b & 0xFFL) << 8 | (long)a & 0xFFL;
    }

    public static Long parseInt64(byte h, byte g, byte f, byte e, byte d, byte c, byte b, byte a) {
        return ((long)h & 0xFFL) << 56 | ((long)g & 0xFFL) << 48 | ((long)f & 0xFFL) << 40 | ((long)e & 0xFFL) << 32 | ((long)d & 0xFFL) << 24 | ((long)c & 0xFFL) << 16 | ((long)b & 0xFFL) << 8 | (long)a & 0xFFL;
    }

    public static BigInteger parseUnsignedInt64(byte h, byte g, byte f, byte e, byte d, byte c, byte b, byte a) {
        int sign = h == 0 && g == 0 && f == 0 && e == 0 && d == 0 && c == 0 && b == 0 && a == 0 ? 0 : 1;
        return new BigInteger(sign, new byte[]{h, g, f, e, d, c, b, a});
    }

    public static Float parseFloat32(byte d, byte c, byte b, byte a) {
        Integer int32 = ByteUtils.parseInt32(d, c, b, a);
        Float result = Float.valueOf(Float.intBitsToFloat(int32));
        if (result.isNaN()) {
            result = null;
        }
        return result;
    }

    public static Double parseFloat64(byte h, byte g, byte f, byte e, byte d, byte c, byte b, byte a) {
        Long l = ByteUtils.parseInt64(h, g, f, e, d, c, b, a);
        Double result = Double.longBitsToDouble(l);
        if (result.isNaN()) {
            result = null;
        }
        return result;
    }

    public static byte[] parseBytes(byte[] data, int offset, int length, ByteOrdering byteOrder) {
        int len = data == null || data.length < 1 ? 0 : (offset + length <= data.length ? length : data.length - offset);
        byte[] bytes = new byte[len];
        if (len > 0) {
            if (byteOrder == ByteOrdering.BigEndian) {
                System.arraycopy(data, offset, bytes, 0, len);
            } else {
                int i = offset + len - 1;
                for (int p = 0; p < len; ++p) {
                    bytes[p] = data[i];
                    --i;
                }
            }
        }
        return bytes;
    }

    public static BigInteger parseInteger(byte[] data, int offset, int length, ByteOrdering byteOrder) {
        BigInteger result;
        byte[] bytes = ByteUtils.parseBytes(data, offset, length, byteOrder);
        try {
            result = new BigInteger(bytes);
        }
        catch (NumberFormatException e) {
            result = BigInteger.ZERO;
        }
        return result;
    }

    public static BigInteger parseUnsignedInteger(byte[] data, int offset, int length, ByteOrdering byteOrder) {
        BigInteger result;
        byte[] bytes = ByteUtils.parseBytes(data, offset, length, byteOrder);
        boolean zero = true;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            zero = false;
            break;
        }
        try {
            result = new BigInteger(zero ? 0 : 1, bytes);
        }
        catch (NumberFormatException e) {
            result = BigInteger.ZERO;
        }
        return result;
    }

    public static BigDecimal parseDecimalCharacterString(byte[] data, int offset, int length, ByteOrdering byteOrder, Charset charset) {
        byte[] bytes = ByteUtils.parseBytes(data, offset, length, byteOrder);
        String s = new String(bytes, charset);
        return new BigDecimal(s);
    }

    public static Byte[] objectArray(byte[] array) {
        if (array == null) {
            return null;
        }
        int count = array.length;
        Byte[] result = new Byte[count];
        for (int i = 0; i < count; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] byteArray(Byte[] array) {
        return ByteUtils.byteArray(array, (byte)0);
    }

    public static byte[] byteArray(Byte[] array, byte nullValue) {
        if (array == null) {
            return null;
        }
        int count = array.length;
        byte[] result = new byte[count];
        for (int i = 0; i < count; ++i) {
            result[i] = array[i] != null ? array[i] : nullValue;
        }
        return result;
    }

    public static String humanReadableByteCount(long count) {
        long absB;
        long l = absB = count == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(count);
        if (absB < 1024L) {
            return count + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(count)) / 1024.0, Character.valueOf(ci.current()));
    }
}

