/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.solarnetwork.domain.SerializeIgnore;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

public final class ClassUtils {
    public static final Set<String> JAVA_PACKAGE_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.", "javax.")));
    private static final Set<String> DEFAULT_BEAN_PROP_NAME_IGNORE = new HashSet<String>(Arrays.asList("class"));

    private ClassUtils() {
    }

    public static <T> T instantiateClass(String className, Class<T> type) {
        Class<T> clazz = ClassUtils.loadClass(className, type);
        try {
            T o = clazz.newInstance();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class [" + className + ']', e);
        }
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> type) {
        try {
            Class<?> clazz;
            ClassLoader loader = type.getClassLoader();
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (!type.isAssignableFrom(clazz = loader.loadClass(className))) {
                throw new RuntimeException("Class [" + clazz + "] is not a [" + type + ']');
            }
            return clazz.asSubclass(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class [" + className + ']', e);
        }
    }

    public static void setBeanProperties(Object o, Map<String, ?> values) {
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)o);
        bean.setAutoGrowNestedPaths(true);
        bean.setPropertyValues(values);
    }

    public static void setBeanProperties(Object o, Map<String, ?> values, boolean ignoreErrors) {
        block3: {
            if (o == null || values == null) {
                return;
            }
            BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)o);
            bean.setAutoGrowNestedPaths(true);
            MutablePropertyValues pvs = new MutablePropertyValues(values);
            try {
                bean.setPropertyValues((PropertyValues)pvs, ignoreErrors, ignoreErrors);
            }
            catch (PropertyBatchUpdateException e) {
                if (ignoreErrors) break block3;
                throw e;
            }
        }
    }

    public static Map<String, Object> getBeanProperties(Object o, Set<String> ignore) {
        PropertyDescriptor[] props;
        if (ignore == null) {
            ignore = DEFAULT_BEAN_PROP_NAME_IGNORE;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)o);
        for (PropertyDescriptor prop : props = bean.getPropertyDescriptors()) {
            Object propValue;
            if (prop.getReadMethod() == null) continue;
            String propName = prop.getName();
            if (ignore != null && ignore.contains(propName) || (propValue = bean.getPropertyValue(propName)) == null) continue;
            result.put(propName, propValue);
        }
        return result;
    }

    public static Map<String, Object> getSimpleBeanProperties(Object o, Set<String> ignore) {
        PropertyDescriptor[] props;
        if (ignore == null) {
            ignore = DEFAULT_BEAN_PROP_NAME_IGNORE;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)o);
        for (PropertyDescriptor prop : props = bean.getPropertyDescriptors()) {
            Object propValue;
            Class propType;
            if (prop.getReadMethod() == null) continue;
            String propName = prop.getName();
            if (ignore != null && ignore.contains(propName) || !(propType = bean.getPropertyType(propName)).isPrimitive() && !propType.isEnum() && !String.class.isAssignableFrom(propType) && !Number.class.isAssignableFrom(propType) && !Character.class.isAssignableFrom(propType) && !Byte.class.isAssignableFrom(propType) && !Date.class.isAssignableFrom(propType) || (propValue = bean.getPropertyValue(propName)) == null) continue;
            if (propType.isEnum()) {
                propValue = propValue.toString();
            } else if (Date.class.isAssignableFrom(propType)) {
                propValue = ((Date)propValue).getTime();
            }
            result.put(propName, propValue);
        }
        return result;
    }

    public static void copyBeanProperties(Object src, Object dest, Set<String> ignore) {
        ClassUtils.copyBeanProperties(src, dest, ignore, false);
    }

    public static void copyBeanProperties(Object src, Object dest, Set<String> ignore, boolean emptyStringToNull) {
        PropertyDescriptor[] props;
        if (ignore == null) {
            ignore = DEFAULT_BEAN_PROP_NAME_IGNORE;
        }
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)src);
        BeanWrapper to = PropertyAccessorFactory.forBeanPropertyAccess((Object)dest);
        for (PropertyDescriptor prop : props = bean.getPropertyDescriptors()) {
            Object propValue;
            if (prop.getReadMethod() == null) continue;
            String propName = prop.getName();
            if (ignore != null && ignore.contains(propName) || (propValue = bean.getPropertyValue(propName)) == null || emptyStringToNull && propValue instanceof String && !StringUtils.hasText((String)((String)propValue)) || !to.isWritableProperty(propName)) continue;
            to.setPropertyValue(propName, propValue);
        }
    }

    public static Map<String, Object> getBeanProperties(Object o, Set<String> ignore, boolean serializeIgnore) {
        PropertyDescriptor[] props;
        if (o == null) {
            return null;
        }
        if (ignore == null) {
            ignore = DEFAULT_BEAN_PROP_NAME_IGNORE;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)o);
        for (PropertyDescriptor prop : props = bean.getPropertyDescriptors()) {
            Method getter;
            Object propValue;
            if (prop.getReadMethod() == null) continue;
            String propName = prop.getName();
            if (ignore != null && ignore.contains(propName) || (propValue = bean.getPropertyValue(propName)) == null || serializeIgnore && (getter = prop.getReadMethod()) != null && getter.isAnnotationPresent(SerializeIgnore.class)) continue;
            result.put(propName, propValue);
        }
        return result;
    }

    public static String getResourceAsString(String resourceName, Class<?> clazz) {
        return ClassUtils.getResourceAsString(resourceName, clazz, null);
    }

    public static String getResourceAsString(String resourceName, Class<?> clazz, Pattern skip) {
        String string;
        block18: {
            InputStream in = clazz.getResourceAsStream(resourceName);
            try {
                if (in == null) {
                    throw new RuntimeException("Resource " + resourceName + " not found from class " + clazz.getName() + ".");
                }
                StringBuilder buf = new StringBuilder(512);
                try (BufferedReader r = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        if (skip != null && skip.matcher(line).find()) continue;
                        buf.append(line).append("\n");
                    }
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                string = buf.toString();
                if (in == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading resource [" + resourceName + "]", e);
                }
            }
            in.close();
        }
        return string;
    }

    private static void addClassesToSetUnlessExcludedByPackagePrefix(Collection<Class<?>> classes, Set<Class<?>> set, Set<String> excluding) {
        if (classes == null) {
            return;
        }
        if (excluding != null) {
            for (Class<?> clazz : classes) {
                String fqn = clazz.getName();
                for (String prefix : excluding) {
                    if (!fqn.startsWith(prefix)) continue;
                    return;
                }
            }
        }
        set.addAll(classes);
    }

    public static Set<Class<?>> getAllNonJavaInterfacesForClassAsSet(Class<?> clazz) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz, JAVA_PACKAGE_PREFIXES);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, Set<String> excluding) {
        LinkedHashSet interfaces = new LinkedHashSet();
        while (clazz != null) {
            Class<?>[] ifcs;
            if (clazz.isInterface()) {
                Set<Class<?>> classes = Collections.singleton(clazz);
                ClassUtils.addClassesToSetUnlessExcludedByPackagePrefix(classes, interfaces, excluding);
            }
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                ClassUtils.addClassesToSetUnlessExcludedByPackagePrefix(ClassUtils.getAllInterfacesForClassAsSet(ifc, excluding), interfaces, excluding);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }
}

