/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.util.IntRange;

public final class DateUtils {
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_ALT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_DATE).parseDefaulting(ChronoField.ERA, ChronoField.ERA.range().getMaximum()).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_TIME).toFormatter().withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_ALT_UTC = ISO_DATE_OPT_TIME_ALT.withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_ALT_LOCAL = ISO_DATE_OPT_TIME_ALT.withZone(ZoneId.systemDefault());
    public static final DateTimeFormatter ISO_DATE_OPT_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_DATE).parseDefaulting(ChronoField.ERA, ChronoField.ERA.range().getMaximum()).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_TIME).toFormatter().withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_UTC = ISO_DATE_OPT_TIME_ALT.withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_LOCAL = ISO_DATE_OPT_TIME_ALT.withZone(ZoneId.systemDefault());
    public static final DateTimeFormatter ISO_DATE_TIME_ALT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseDefaulting(ChronoField.ERA, ChronoField.ERA.range().getMaximum()).appendLiteral(' ').append(DateTimeFormatter.ISO_TIME).toFormatter().withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_TIME_ALT_UTC = ISO_DATE_TIME_ALT.withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter();
    public static final DateTimeFormatter LOCAL_DATE = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final DateTimeFormatter LOCAL_TIME_FULL = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final DateTimeFormatter DISPLAY_DATE_LONG_TIME_SHORT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.SHORT);
    public static final DateTimeFormatter ISO_LOCAL_TIME_OPT_MILLIS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).toFormatter().withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_OPT_MILLIS_ALT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseDefaulting(ChronoField.ERA, ChronoField.ERA.range().getMaximum()).optionalStart().appendLiteral(' ').append(ISO_LOCAL_TIME_OPT_MILLIS).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, ChronoField.HOUR_OF_DAY.range().getMinimum()).parseDefaulting(ChronoField.MINUTE_OF_HOUR, ChronoField.MINUTE_OF_HOUR.range().getMinimum()).parseDefaulting(ChronoField.SECOND_OF_MINUTE, ChronoField.SECOND_OF_MINUTE.range().getMinimum()).parseDefaulting(ChronoField.MILLI_OF_SECOND, ChronoField.MILLI_OF_SECOND.range().getMinimum()).toFormatter().withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_OPT_MILLIS_ALT_UTC = ISO_DATE_OPT_TIME_OPT_MILLIS_ALT.withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_OPT_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).parseDefaulting(ChronoField.ERA, ChronoField.ERA.range().getMaximum()).optionalStart().appendLiteral('T').append(ISO_LOCAL_TIME_OPT_MILLIS).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, ChronoField.HOUR_OF_DAY.range().getMinimum()).parseDefaulting(ChronoField.MINUTE_OF_HOUR, ChronoField.MINUTE_OF_HOUR.range().getMinimum()).parseDefaulting(ChronoField.SECOND_OF_MINUTE, ChronoField.SECOND_OF_MINUTE.range().getMinimum()).parseDefaulting(ChronoField.MILLI_OF_SECOND, ChronoField.MILLI_OF_SECOND.range().getMinimum()).toFormatter().withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter ISO_DATE_OPT_TIME_OPT_MILLIS_UTC = ISO_DATE_OPT_TIME_OPT_MILLIS.withZone(ZoneOffset.UTC);
    public static final Pattern RANGE_DELIMITER = Pattern.compile("\\s*-\\s*");
    public static final int MINUTES_PER_DAY = 1440;

    public static ZonedDateTime parseIsoAltTimestamp(String value, ZoneId defaultZone) {
        return DateUtils.parseIsoTimestamp(ISO_DATE_OPT_TIME_ALT, value, defaultZone);
    }

    public static ZonedDateTime parseIsoTimestamp(String value, ZoneId defaultZone) {
        return DateUtils.parseIsoTimestamp(ISO_DATE_OPT_TIME, value, defaultZone);
    }

    public static ZonedDateTime parseIsoTimestamp(DateTimeFormatter formatter, String value, ZoneId defaultZone) {
        ZonedDateTime result = null;
        try {
            result = formatter.parse((CharSequence)value, ZonedDateTime::from);
        }
        catch (DateTimeException e) {
            try {
                TemporalAccessor ta = formatter.parse(value);
                ZoneId zone = ta.query(TemporalQueries.zone());
                if (zone == null) {
                    zone = defaultZone;
                }
                try {
                    result = LocalDateTime.from(ta).atZone(zone);
                }
                catch (DateTimeException e3) {
                    try {
                        result = LocalDate.from(ta).atStartOfDay(zone);
                    }
                    catch (DateTimeException dateTimeException) {}
                }
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return result;
    }

    private static String[] splitRange(String range) {
        if (range == null) {
            return null;
        }
        Matcher m = RANGE_DELIMITER.matcher(range = range.trim());
        if (m.find() && m.end() < range.length()) {
            String a = range.substring(0, m.start());
            String b = range.substring(m.end(), range.length());
            return new String[]{a, b};
        }
        return new String[]{range, range};
    }

    private static IntRange parseRange(String[] r, Locale locale, TemporalField field, TextStyle style) throws DateTimeException {
        DateTimeFormatter f = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendText(field, style).toFormatter(locale);
        TemporalAccessor a = f.parse(r[0]);
        if (r[0].equals(r[1])) {
            return IntRange.rangeOf(a.get(field));
        }
        TemporalAccessor b = f.parse(r[1]);
        return IntRange.rangeOf(a.get(field), b.get(field));
    }

    public static IntRange parseRange(TemporalField field, String range, Locale locale) throws DateTimeException {
        if (range == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateUtils.parseRange(DateUtils.splitRange(range), locale, field, TextStyle.FULL);
    }

    public static IntRange parseMonthRange(String range, Locale locale) throws DateTimeException {
        return DateUtils.parseRange(ChronoField.MONTH_OF_YEAR, range, locale);
    }

    public static IntRange parseDayOfMonthRange(String range, Locale locale) throws DateTimeException {
        return DateUtils.parseRange(ChronoField.DAY_OF_MONTH, range, locale);
    }

    public static IntRange parseDayOfWeekRange(String range, Locale locale) throws DateTimeException {
        return DateUtils.parseRange(ChronoField.DAY_OF_WEEK, range, locale);
    }

    public static IntRange parseMinuteOfDayRange(String range, Locale locale) throws DateTimeException {
        return DateUtils.parseMinuteOfDayRange(range, locale, false);
    }

    public static IntRange parseMinuteOfDayRange(String range, Locale locale, boolean fix24) throws DateTimeException {
        String[] r = DateUtils.splitRange(range);
        if (r == null) {
            return null;
        }
        int[] n = new int[2];
        try {
            for (int i = 0; i < 2; ++i) {
                String s = r[i];
                int h = 0;
                int m = 0;
                int idx = s.indexOf(58);
                if (idx > 0) {
                    h = Integer.parseInt(s.substring(0, idx));
                    m = Integer.parseInt(s.substring(idx + 1));
                } else {
                    h = Integer.parseInt(r[i]);
                }
                if (h < 0 || h > 24) {
                    throw new DateTimeException("Hour of day out of range: " + h);
                }
                if (fix24 && h == 24) {
                    h = 23;
                    if (m == 0) {
                        m = 59;
                    }
                }
                if (m < 0 || m > 59) {
                    throw new DateTimeException("Minute of hour out of range: " + m);
                }
                n[i] = h * 60 + m;
            }
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("Invalid hour of day range", range, 0, e);
        }
        return IntRange.rangeOf(n[0], n[1]);
    }

    private static String formatMinuteOfDay(int moh) {
        int h = moh / 60;
        int m = moh - h * 60;
        return String.format("%02d:%02d", h, m);
    }

    private static String formatRange(IntRange range, Locale locale, ChronoField field, TextStyle style) throws DateTimeException {
        StringBuilder buf = new StringBuilder();
        if (field == ChronoField.MINUTE_OF_DAY) {
            if (range.getMin() < 0 || range.getMax() > 1440) {
                throw new DateTimeException("The start minute of hour is out of range: " + range.getMin());
            }
            if (range.getMax() < 0 || range.getMax() > 1440) {
                throw new DateTimeException("The end minute of hour is out of range: " + range.getMax());
            }
            if (style == TextStyle.SHORT && range.getMin() % 60 == 0 && range.getMax() % 60 == 0) {
                buf.append(range.getMin() / 60);
                if (range.getMax() != range.getMin()) {
                    buf.append('-').append(range.getMax() / 60);
                }
            } else {
                buf.append(DateUtils.formatMinuteOfDay(range.getMin()));
                if (range.getMax() != range.getMin()) {
                    buf.append('-').append(DateUtils.formatMinuteOfDay(range.getMax()));
                }
            }
        } else {
            DateTimeFormatter f = new DateTimeFormatterBuilder().appendText((TemporalField)field, style).toFormatter(locale);
            LocalDateTime t = LocalDateTime.now();
            t = field == ChronoField.DAY_OF_WEEK ? t.with(TemporalAdjusters.nextOrSame(DayOfWeek.of(range.getMin()))) : t.with(field, range.getMin());
            f.formatTo(t, buf);
            if (range.getMax() != range.getMin()) {
                buf.append('-');
                t = field == ChronoField.DAY_OF_WEEK ? t.with(TemporalAdjusters.nextOrSame(DayOfWeek.of(range.getMax()))) : t.with(field, range.getMax());
                f.formatTo(t, buf);
            }
        }
        return buf.toString();
    }

    public static String formatRange(ChronoField field, IntRange range, Locale locale, TextStyle style) throws DateTimeException {
        if (range == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateUtils.formatRange(range, locale, field, style);
    }

    public static String formatHoursMinutesSeconds(long milliseconds) {
        long totalSeconds = milliseconds / 1000L;
        long hours = (int)(totalSeconds / 3600L);
        int minutes = (int)(totalSeconds % 3600L / 60L);
        int seconds = (int)(totalSeconds % 60L);
        if (hours > 23L) {
            int days = (int)hours / 24;
            return String.format("%dd %02d:%02d:%02d", days, hours -= (long)(days * 24), minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static LocalTime parseLocalTime(String value) {
        return LOCAL_TIME.parse((CharSequence)value, LocalTime::from);
    }

    public static String format(LocalTime value) {
        return LOCAL_TIME.format(value);
    }

    public static LocalDate parseLocalDate(String value) {
        return DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)value, LocalDate::from);
    }

    public static String format(LocalDate value) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(value);
    }

    public static String formatForLocalDisplay(Instant timestamp) {
        return DISPLAY_DATE_LONG_TIME_SHORT.format(timestamp.atZone(ZoneId.systemDefault()));
    }
}

