/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.io.Serializable;
import java.util.Objects;

public final class IntRange
implements Serializable,
Comparable<IntRange> {
    private static final long serialVersionUID = 2815680548854317296L;
    private final int min;
    private final int max;

    public IntRange(int min, int max) {
        this.min = min < max ? min : max;
        this.max = max > min ? max : min;
    }

    public static IntRange rangeOf(int value) {
        return new IntRange(value, value);
    }

    public static IntRange rangeOf(int min, int max) {
        return new IntRange(min, max);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int length() {
        return this.max - this.min + 1;
    }

    public boolean isSingleton() {
        return this.max == this.min;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public boolean containsAll(int min, int max) {
        return min <= max && min >= this.min && max <= this.max;
    }

    public boolean containsAll(IntRange o) {
        return this.containsAll(o.getMin(), o.getMax());
    }

    public boolean intersects(IntRange o) {
        return this.min >= o.min && this.min <= o.max || o.min >= this.min && o.min <= this.max;
    }

    public boolean adjacentTo(IntRange o) {
        return this.max + 1 == o.min || o.max + 1 == this.min;
    }

    public boolean canMergeWith(IntRange o) {
        return o != null && (this.intersects(o) || this.adjacentTo(o));
    }

    public IntRange mergeWith(IntRange o) {
        int b;
        if (!this.canMergeWith(o)) {
            throw new IllegalArgumentException("IntRange " + this + " cannot be merged with " + o);
        }
        int a = this.min < o.min ? this.min : o.min;
        int n = b = this.max > o.max ? this.max : o.max;
        return a == this.min && b == this.max ? this : (a == o.min && b == o.max ? o : new IntRange(a, b));
    }

    @Override
    public int compareTo(IntRange o) {
        return this.min < o.min ? -1 : (this.min > o.min ? 1 : 0);
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntRange)) {
            return false;
        }
        IntRange other = (IntRange)obj;
        return this.max == other.max && this.min == other.min;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.min);
        builder.append("..");
        builder.append(this.max);
        builder.append("]");
        return builder.toString();
    }
}

