/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.IntConsumer;
import net.solarnetwork.util.IntOrderedIterable;
import net.solarnetwork.util.IntRange;

public class IntRangeSet
extends AbstractSet<Integer>
implements NavigableSet<Integer>,
IntOrderedIterable,
Cloneable {
    private final boolean immutable;
    private final List<IntRange> ranges;

    public IntRangeSet() {
        this(16);
    }

    public IntRangeSet(int initialCapacity) {
        this.ranges = new ArrayList<IntRange>(initialCapacity);
        this.immutable = false;
    }

    public IntRangeSet(Collection<Integer> c) {
        this();
        this.addAll((Collection<? extends Integer>)c);
    }

    public IntRangeSet(IntRange ... ranges) {
        this(ranges != null ? ranges.length : 16);
        if (ranges != null) {
            for (IntRange r : ranges) {
                this.addRange(r.getMin(), r.getMax());
            }
        }
    }

    private IntRangeSet(List<IntRange> ranges, boolean immutable) {
        this.ranges = new ArrayList<IntRange>(ranges.size());
        this.ranges.addAll(ranges);
        this.immutable = immutable;
    }

    public IntRangeSet immutableCopy() {
        if (this.immutable) {
            return this;
        }
        return new IntRangeSet(this.ranges, true);
    }

    public Object clone() {
        return new IntRangeSet(this.ranges, this.immutable);
    }

    @Override
    public String toString() {
        return this.ranges.toString();
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        Objects.requireNonNull(action);
        for (IntRange r : this.ranges) {
            for (int i = r.getMin(); i <= r.getMax(); ++i) {
                action.accept(i);
                if (i != Integer.MAX_VALUE) continue;
                return;
            }
        }
    }

    @Override
    public void forEachOrdered(int min, int max, IntConsumer action) {
        Objects.requireNonNull(action);
        for (IntRange r : this.ranges) {
            int stop;
            if (min > r.getMax()) continue;
            if (max <= r.getMin()) break;
            int i = r.getMin();
            if (i < min) {
                i = min;
            }
            int n = stop = max <= r.getMax() ? max - 1 : r.getMax();
            while (i <= stop) {
                action.accept(i);
                if (i == Integer.MAX_VALUE) {
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean add(Integer e) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        if (e == null) {
            throw new IllegalArgumentException("Integer cannot be null");
        }
        return this.add((int)e);
    }

    @Override
    public boolean add(int v) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        IntRange p = null;
        boolean changed = false;
        if (this.ranges.isEmpty()) {
            this.ranges.add(new IntRange(v, v));
            changed = true;
        } else {
            ListIterator<IntRange> itr = this.ranges.listIterator();
            while (itr.hasNext()) {
                IntRange r = itr.next();
                if (r.contains(v)) {
                    return false;
                }
                if (v < r.getMin()) {
                    if (v + 1 == r.getMin()) {
                        if (p != null && v - 1 == p.getMax()) {
                            itr.remove();
                            this.ranges.set(itr.previousIndex(), new IntRange(p.getMin(), r.getMax()));
                        } else {
                            itr.set(new IntRange(v, r.getMax()));
                        }
                    } else if (p != null && v - 1 == p.getMax()) {
                        this.ranges.set(itr.previousIndex() - 1, new IntRange(p.getMin(), v));
                    } else {
                        this.ranges.add(itr.previousIndex(), new IntRange(v, v));
                    }
                    changed = true;
                    break;
                }
                p = r;
            }
            if (!changed) {
                if (p != null && v - 1 == p.getMax()) {
                    this.ranges.set(this.ranges.size() - 1, new IntRange(p.getMin(), v));
                } else {
                    this.ranges.add(new IntRange(v, v));
                }
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> col) {
        int a;
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        if (col == null || col.isEmpty()) {
            return false;
        }
        int[] sorted = col.stream().mapToInt(Integer::intValue).toArray();
        Arrays.sort(sorted);
        int len = sorted.length;
        if (len == 1) {
            return this.add(sorted[0]);
        }
        int b = a = sorted[0];
        boolean changed = false;
        for (int i = 1; i < len; ++i) {
            int c = sorted[i];
            int d = c - b;
            if (d > 1) {
                changed |= this.addRange(a, b);
                a = c;
            }
            b = c;
        }
        return changed |= this.addRange(a, b);
    }

    public boolean addRange(int min, int max) {
        return this.addRange(new IntRange(min, max));
    }

    public boolean addRange(IntRange range) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        boolean changed = false;
        if (this.ranges.isEmpty()) {
            this.ranges.add(range);
            changed = true;
        } else {
            ListIterator<IntRange> itr = this.ranges.listIterator();
            while (itr.hasNext()) {
                IntRange r = itr.next();
                if (r.containsAll(range)) {
                    return false;
                }
                if (r.canMergeWith(range)) {
                    IntRange merged = r.mergeWith(range);
                    while (itr.hasNext()) {
                        IntRange n = itr.next();
                        if (merged.canMergeWith(n)) {
                            merged = merged.mergeWith(n);
                            itr.remove();
                            continue;
                        }
                        itr.previous();
                        break;
                    }
                    this.ranges.set(itr.previousIndex(), merged);
                    changed = true;
                    break;
                }
                if (range.getMin() >= r.getMin()) continue;
                this.ranges.add(itr.previousIndex(), range);
                changed = true;
                break;
            }
            if (!changed) {
                this.ranges.add(range);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public void clear() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        this.ranges.clear();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntegerIterator();
    }

    public Iterable<IntRange> ranges() {
        return this.ranges;
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public int size() {
        return this.ranges.stream().mapToInt(IntRange::length).sum();
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public Integer first() {
        IntRange r = this.ranges.isEmpty() ? null : this.ranges.get(0);
        return r != null ? Integer.valueOf(r.getMin()) : null;
    }

    @Override
    public Integer last() {
        IntRange r = this.ranges.isEmpty() ? null : this.ranges.get(this.ranges.size() - 1);
        return r != null ? Integer.valueOf(r.getMax()) : null;
    }

    @Override
    public Integer lower(Integer e) {
        int v = e;
        ListIterator<IntRange> itr = this.ranges.listIterator();
        while (itr.hasNext()) {
            IntRange r = itr.next();
            if (r.contains(v) || r.getMin() >= v) {
                if (v > r.getMin()) {
                    return v - 1;
                }
                if (itr.previousIndex() <= 0) break;
                return this.ranges.get(itr.previousIndex() - 1).getMax();
            }
            if (r.getMax() >= v || itr.hasNext()) continue;
            return r.getMax();
        }
        return null;
    }

    @Override
    public Integer floor(Integer e) {
        int v = e;
        ListIterator<IntRange> itr = this.ranges.listIterator();
        while (itr.hasNext()) {
            IntRange r = itr.next();
            if (r.contains(v)) {
                return v;
            }
            if (r.getMin() > v) {
                if (itr.previousIndex() <= 0) break;
                return this.ranges.get(itr.previousIndex() - 1).getMax();
            }
            if (r.getMax() >= v || itr.hasNext()) continue;
            return r.getMax();
        }
        return null;
    }

    @Override
    public Integer ceiling(Integer e) {
        int v = e;
        int len = this.ranges.size();
        ListIterator<IntRange> itr = this.ranges.listIterator(len);
        while (itr.hasPrevious()) {
            IntRange r = itr.previous();
            if (r.contains(v)) {
                return v;
            }
            if (r.getMax() < v) {
                if (itr.nextIndex() + 1 >= len) break;
                return this.ranges.get(itr.nextIndex() + 1).getMin();
            }
            if (r.getMin() <= v || itr.hasPrevious()) continue;
            return r.getMin();
        }
        return null;
    }

    @Override
    public Integer higher(Integer e) {
        int v = e;
        int len = this.ranges.size();
        ListIterator<IntRange> itr = this.ranges.listIterator(len);
        while (itr.hasPrevious()) {
            IntRange r = itr.previous();
            if (r.contains(v) || r.getMax() <= v) {
                if (v < r.getMax()) {
                    return v + 1;
                }
                if (itr.nextIndex() + 1 >= len) break;
                return this.ranges.get(itr.nextIndex() + 1).getMin();
            }
            if (r.getMin() <= v || itr.hasPrevious()) continue;
            return r.getMin();
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        if (!(o instanceof Integer)) {
            return false;
        }
        int v = (Integer)o;
        ListIterator<IntRange> itr = this.ranges.listIterator();
        while (itr.hasNext()) {
            IntRange r = itr.next();
            if (!r.contains(v)) continue;
            if (v == r.getMin()) {
                if (v < r.getMax()) {
                    itr.set(new IntRange(v + 1, r.getMax()));
                } else {
                    itr.remove();
                }
            } else if (v == r.getMax()) {
                itr.set(new IntRange(r.getMin(), v - 1));
            } else {
                itr.set(new IntRange(r.getMin(), v - 1));
                this.ranges.add(itr.nextIndex(), new IntRange(v + 1, r.getMax()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        if (c == null) {
            return false;
        }
        boolean modified = false;
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            modified |= this.remove(i.next());
        }
        return modified;
    }

    @Override
    public Integer pollFirst() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        if (this.ranges.isEmpty()) {
            return null;
        }
        IntRange old = this.ranges.get(0);
        if (old.isSingleton()) {
            this.ranges.remove(0);
        } else {
            this.ranges.set(0, new IntRange(old.getMin() + 1, old.getMax()));
        }
        return old.getMin();
    }

    @Override
    public Integer pollLast() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Set it immutable.");
        }
        if (this.ranges.isEmpty()) {
            return null;
        }
        int lastIndex = this.ranges.size() - 1;
        IntRange old = this.ranges.get(lastIndex);
        if (old.isSingleton()) {
            this.ranges.remove(lastIndex);
        } else {
            this.ranges.set(lastIndex, new IntRange(old.getMin(), old.getMax() - 1));
        }
        return old.getMax();
    }

    @Override
    public NavigableSet<Integer> descendingSet() {
        return new ReverseSet(this);
    }

    @Override
    public Iterator<Integer> descendingIterator() {
        return new IntegerReverseIterator();
    }

    @Override
    public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public NavigableSet<Integer> subSet(Integer fromElement, boolean fromInclusive, Integer toElement, boolean toInclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Integer> headSet(Integer toElement, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Integer> tailSet(Integer fromElement, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<Integer> headSet(Integer toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<Integer> tailSet(Integer fromElement) {
        return this.tailSet(fromElement, true);
    }

    private class IntegerIterator
    implements Iterator<Integer> {
        private final Iterator<IntRange> rangeItr;
        private IntRange curr;
        private int next;

        private IntegerIterator() {
            this.rangeItr = IntRangeSet.this.ranges.iterator();
            if (this.rangeItr.hasNext()) {
                this.curr = this.rangeItr.next();
                this.next = this.curr.getMin();
            } else {
                this.curr = null;
            }
        }

        private IntegerIterator(int min, int max) {
            this.rangeItr = IntRangeSet.this.ranges.iterator();
            this.next = min;
            while (this.rangeItr.hasNext()) {
                this.curr = this.rangeItr.next();
                if (!this.curr.contains(min)) continue;
            }
            if (!this.curr.contains(min)) {
                this.curr = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.curr != null && (this.next <= this.curr.getMax() || this.rangeItr.hasNext());
        }

        @Override
        public Integer next() {
            if (this.curr == null) {
                throw new NoSuchElementException();
            }
            int n = this.next++;
            if (!this.curr.contains(this.next)) {
                if (this.rangeItr.hasNext()) {
                    this.curr = this.rangeItr.next();
                    this.next = this.curr.getMin();
                } else {
                    this.curr = null;
                }
            }
            return n;
        }
    }

    private static class ReverseSet
    extends AbstractSet<Integer>
    implements NavigableSet<Integer> {
        private final IntRangeSet delegate;

        private ReverseSet(IntRangeSet delegate) {
            this.delegate = delegate;
        }

        @Override
        public Comparator<? super Integer> comparator() {
            return null;
        }

        @Override
        public boolean add(Integer e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends Integer> col) {
            return this.delegate.addAll(col);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Integer first() {
            return this.delegate.last();
        }

        @Override
        public Integer last() {
            return this.delegate.first();
        }

        @Override
        public Integer lower(Integer e) {
            return this.delegate.higher(e);
        }

        @Override
        public Integer floor(Integer e) {
            return this.delegate.ceiling(e);
        }

        @Override
        public Integer ceiling(Integer e) {
            return this.delegate.floor(e);
        }

        @Override
        public Integer higher(Integer e) {
            return this.delegate.lower(e);
        }

        @Override
        public Integer pollFirst() {
            return this.delegate.pollLast();
        }

        @Override
        public Integer pollLast() {
            return this.delegate.pollFirst();
        }

        @Override
        public NavigableSet<Integer> descendingSet() {
            return this.delegate;
        }

        @Override
        public Iterator<Integer> descendingIterator() {
            return this.delegate.iterator();
        }

        @Override
        public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<Integer> subSet(Integer fromElement, boolean fromInclusive, Integer toElement, boolean toInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<Integer> headSet(Integer toElement, boolean inclusive) {
            return this.delegate.tailSet(toElement, inclusive);
        }

        @Override
        public NavigableSet<Integer> tailSet(Integer fromElement, boolean inclusive) {
            return this.delegate.headSet(fromElement, inclusive);
        }

        @Override
        public SortedSet<Integer> headSet(Integer toElement) {
            return this.delegate.tailSet(toElement);
        }

        @Override
        public SortedSet<Integer> tailSet(Integer fromElement) {
            return this.delegate.headSet(fromElement);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.delegate.descendingIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }

    private class IntegerReverseIterator
    implements Iterator<Integer> {
        private final ListIterator<IntRange> rangeItr;
        private IntRange curr;
        private int next;

        private IntegerReverseIterator() {
            this.rangeItr = IntRangeSet.this.ranges.listIterator(IntRangeSet.this.ranges.size());
            if (this.rangeItr.hasPrevious()) {
                this.curr = this.rangeItr.previous();
                this.next = this.curr.getMax();
            } else {
                this.curr = null;
            }
        }

        private IntegerReverseIterator(int min, int max) {
            this.rangeItr = IntRangeSet.this.ranges.listIterator(IntRangeSet.this.ranges.size());
            this.next = min;
            while (this.rangeItr.hasPrevious()) {
                this.curr = this.rangeItr.previous();
                if (!this.curr.contains(max)) continue;
            }
            if (!this.curr.contains(max)) {
                this.curr = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.curr != null && (this.next >= this.curr.getMin() || this.rangeItr.hasPrevious());
        }

        @Override
        public Integer next() {
            if (this.curr == null) {
                throw new NoSuchElementException();
            }
            int n = this.next--;
            if (!this.curr.contains(this.next)) {
                if (this.rangeItr.hasPrevious()) {
                    this.curr = this.rangeItr.previous();
                    this.next = this.curr.getMax();
                } else {
                    this.curr = null;
                }
            }
            return n;
        }
    }
}

