/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.solarnetwork.util.IntShortBiConsumer;
import net.solarnetwork.util.IntShortOrderedIterable;

public class IntShortMap
extends AbstractMap<Integer, Short>
implements Map<Integer, Short>,
IntShortOrderedIterable,
Cloneable {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final short VALUE_NO_SUCH_ELEMENT = Short.MIN_VALUE;
    private final int initialCapacity;
    private final short notFoundValue;
    private int[] keys;
    private short[] values;
    private int size;

    public IntShortMap() {
        this(16, 0);
    }

    public IntShortMap(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntShortMap(int initialCapacity, short notFoundValue) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("The initial capacity must be 1 or more.");
        }
        this.initialCapacity = initialCapacity;
        this.notFoundValue = notFoundValue;
        this.keys = new int[initialCapacity];
        this.values = new short[initialCapacity];
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int len = this.size;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.keys[i]).append("=").append(this.values[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public Object clone() {
        IntShortMap m = new IntShortMap(this.size > 0 ? this.size : this.getCapacity(), this.notFoundValue);
        System.arraycopy(this.keys, 0, m.keys, 0, this.size);
        System.arraycopy(this.values, 0, m.values, 0, this.size);
        m.size = this.size;
        return m;
    }

    @Override
    public Set<Map.Entry<Integer, Short>> entrySet() {
        return new EntrySet();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void forEachOrdered(IntShortBiConsumer action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.keys[i], this.values[i]);
            if (i != Integer.MAX_VALUE) continue;
            return;
        }
    }

    @Override
    public void forEachOrdered(int min, int max, IntShortBiConsumer action) {
        Objects.requireNonNull(action);
        int start = Arrays.binarySearch(this.keys, 0, this.size, min);
        if (start < 0) {
            start = -(start + 1);
        }
        for (int i = start; i < this.size && this.keys[i] < max; ++i) {
            action.accept(this.keys[i], this.values[i]);
            if (i != Integer.MAX_VALUE) continue;
            return;
        }
    }

    @Override
    public Set<Integer> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Short> values() {
        int len = this.size;
        ArrayList<Short> l = new ArrayList<Short>(len);
        for (int i = 0; i < len; ++i) {
            l.add(this.values[i]);
        }
        return l;
    }

    @Override
    public boolean containsValue(Object value) {
        short v = (Short)value;
        for (int i = 0; i < this.size; ++i) {
            if (v != this.values[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    public boolean containsKey(int k) {
        int idx = Arrays.binarySearch(this.keys, 0, this.size, k);
        return idx >= 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public int getCapacity() {
        return this.keys.length;
    }

    public boolean compact() {
        if (this.keys.length < this.initialCapacity || this.size == this.keys.length) {
            return false;
        }
        int[] newKeys = new int[this.size];
        short[] newValues = new short[this.size];
        System.arraycopy(this.keys, 0, newKeys, 0, this.size);
        System.arraycopy(this.values, 0, newValues, 0, this.size);
        this.keys = newKeys;
        this.values = newValues;
        return true;
    }

    @Override
    public Short get(Object key) {
        int k = (Integer)key;
        return this.get(k);
    }

    public Short get(int k) {
        int idx = Arrays.binarySearch(this.keys, 0, this.size, k);
        if (idx >= 0) {
            return this.values[idx];
        }
        return null;
    }

    public short getValue(int k) {
        int idx = Arrays.binarySearch(this.keys, 0, this.size, k);
        if (idx >= 0) {
            return this.values[idx];
        }
        if (this.notFoundValue == Short.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.notFoundValue;
    }

    public Short putValue(int k, int value) {
        return this.putValue(k, (short)value);
    }

    public Short putValue(int k, short value) {
        int idx = this.size == 0 || k > this.keys[this.size - 1] ? -this.size - 1 : Arrays.binarySearch(this.keys, 0, this.size, k);
        Short prev = null;
        if (idx >= 0 && this.size > 0) {
            prev = this.values[idx];
            this.values[idx] = value;
        } else {
            int p = -(idx + 1);
            if (this.size >= this.keys.length) {
                this.expandCapacity();
            }
            if (p < this.size) {
                System.arraycopy(this.keys, p, this.keys, p + 1, this.size - p);
                System.arraycopy(this.values, p, this.values, p + 1, this.size - p);
            }
            this.keys[p] = k;
            this.values[p] = value;
            ++this.size;
        }
        return prev;
    }

    @Override
    public Short put(Integer key, Short value) {
        return this.putValue((int)key, value);
    }

    public Map<Integer, Integer> unsignedMap() {
        final UnsignedIntegerEntrySet entrySet = new UnsignedIntegerEntrySet();
        return new AbstractMap<Integer, Integer>(){

            @Override
            public boolean containsKey(Object key) {
                return IntShortMap.this.containsKey(key);
            }

            @Override
            public Integer get(Object key) {
                Integer result = null;
                Short v = IntShortMap.this.get(key);
                if (v != null) {
                    result = Short.toUnsignedInt(v);
                }
                return result;
            }

            @Override
            public Set<Map.Entry<Integer, Integer>> entrySet() {
                return entrySet;
            }

            @Override
            public Integer put(Integer key, Integer value) {
                Short v = value.shortValue();
                Short prev = IntShortMap.this.put(key, v);
                return prev != null ? Integer.valueOf(Short.toUnsignedInt(prev)) : null;
            }
        };
    }

    private void expandCapacity() {
        int oldLen = this.keys.length;
        int newLen = oldLen + oldLen / 2 + 1;
        int[] newKeys = new int[newLen];
        System.arraycopy(this.keys, 0, newKeys, 0, oldLen);
        short[] newValues = new short[newLen];
        System.arraycopy(this.values, 0, newValues, 0, oldLen);
        this.keys = newKeys;
        this.values = newValues;
    }

    private void removeKeyAtIndex(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        --this.size;
        System.arraycopy(this.keys, idx + 1, this.keys, idx, this.size - idx);
        System.arraycopy(this.values, idx + 1, this.values, idx, this.size - idx);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Short>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Short>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return IntShortMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Short v = IntShortMap.this.get(e.getKey());
            return Objects.equals(e.getValue(), v);
        }

        @Override
        public void clear() {
            IntShortMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return IntShortMap.this.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Short v = IntShortMap.this.get(e.getKey());
            if (Objects.equals(e.getValue(), v)) {
                return IntShortMap.this.remove(e.getKey()) != null;
            }
            return false;
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<Integer, Short>> {
            private int idx = 0;

            private EntryIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.idx < IntShortMap.this.size;
            }

            @Override
            public Map.Entry<Integer, Short> next() {
                int i = this.idx++;
                return new AbstractMap.SimpleImmutableEntry<Integer, Short>(IntShortMap.this.keys[i], IntShortMap.this.values[i]);
            }

            @Override
            public void remove() {
                IntShortMap.this.removeKeyAtIndex(--this.idx);
            }
        }
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return IntShortMap.this.size;
        }
    }

    private final class UnsignedIntegerEntrySet
    extends AbstractSet<Map.Entry<Integer, Integer>> {
        private UnsignedIntegerEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Integer>> iterator() {
            return new UnsignedEntryIterator();
        }

        @Override
        public int size() {
            return IntShortMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Short v = IntShortMap.this.get(e.getKey());
            return Objects.equals(((Integer)e.getValue()).shortValue(), v);
        }

        @Override
        public void clear() {
            IntShortMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return IntShortMap.this.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Short v = IntShortMap.this.get(e.getKey());
            if (Objects.equals(((Integer)e.getValue()).shortValue(), v)) {
                return IntShortMap.this.remove(e.getKey()) != null;
            }
            return false;
        }

        private final class UnsignedEntryIterator
        implements Iterator<Map.Entry<Integer, Integer>> {
            private int idx = 0;

            private UnsignedEntryIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.idx < IntShortMap.this.size;
            }

            @Override
            public Map.Entry<Integer, Integer> next() {
                int i = this.idx++;
                return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(IntShortMap.this.keys[i], Short.toUnsignedInt(IntShortMap.this.values[i]));
            }

            @Override
            public void remove() {
                IntShortMap.this.removeKeyAtIndex(--this.idx);
            }
        }
    }

    private final class KeyIterator
    implements Iterator<Integer> {
        private int idx = 0;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < IntShortMap.this.size;
        }

        @Override
        public Integer next() {
            if (this.idx >= IntShortMap.this.size) {
                throw new NoSuchElementException();
            }
            return IntShortMap.this.keys[this.idx++];
        }

        @Override
        public void remove() {
            IntShortMap.this.removeKeyAtIndex(--this.idx);
        }
    }
}

