/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.ArrayDeque;
import java.util.Deque;

public class LimitedSizeDeque<E>
extends ArrayDeque<E>
implements Deque<E> {
    private static final long serialVersionUID = -2004653495520273734L;
    private final int maximumSize;

    public LimitedSizeDeque(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    @Override
    public void addFirst(E e) {
        while (this.size() >= this.maximumSize) {
            this.removeLast();
        }
        super.addFirst(e);
    }

    @Override
    public void addLast(E e) {
        while (this.size() >= this.maximumSize) {
            this.removeFirst();
        }
        super.addLast(e);
    }
}

