/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import net.solarnetwork.domain.NodeControlPropertyType;
import net.solarnetwork.util.StringUtils;

public final class NodeControlUtils {
    public static String controlValue(NodeControlPropertyType type, Object value) {
        String controlValue = null;
        switch (type) {
            case Boolean: {
                controlValue = NodeControlUtils.booleanControlValue(value);
                break;
            }
            case Float: {
                controlValue = NodeControlUtils.floatControlValue(value);
                break;
            }
            case Integer: {
                controlValue = NodeControlUtils.integerControlValue(value);
                break;
            }
            case Percent: {
                controlValue = NodeControlUtils.percentControlValue(value);
                break;
            }
            case String: {
                controlValue = NodeControlUtils.stringControlValue(value);
            }
        }
        return controlValue;
    }

    public static String booleanControlValue(Object value) {
        Boolean b = null;
        b = value instanceof Boolean ? (Boolean)value : (value instanceof String ? Boolean.valueOf(StringUtils.parseBoolean((String)value)) : (value instanceof Number ? (((Number)value).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE) : Boolean.valueOf(value == null ? Boolean.FALSE : StringUtils.parseBoolean(value.toString()))));
        return b.toString();
    }

    public static String floatControlValue(Object value) {
        BigDecimal n = null;
        if (value instanceof BigDecimal) {
            n = (BigDecimal)value;
        } else if (value instanceof Number) {
            n = new BigDecimal(value.toString());
        }
        return n != null ? n.toString() : null;
    }

    public static String integerControlValue(Object value) {
        BigInteger n = null;
        if (value instanceof BigInteger) {
            n = (BigInteger)value;
        } else if (value instanceof BigDecimal) {
            n = ((BigDecimal)value).setScale(0, RoundingMode.HALF_UP).toBigInteger();
        } else if (value instanceof Number) {
            n = new BigDecimal(value.toString()).setScale(0, RoundingMode.HALF_UP).toBigInteger();
        }
        return n != null ? n.toString() : null;
    }

    public static String percentControlValue(Object value) {
        BigDecimal d = null;
        if (value instanceof BigDecimal) {
            d = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            d = new BigDecimal((BigInteger)value).movePointLeft(2);
        } else if (value instanceof Integer) {
            d = new BigDecimal((Integer)value).movePointLeft(2);
        } else if (value instanceof Long) {
            d = new BigDecimal((Long)value).movePointLeft(2);
        } else if (value instanceof Number) {
            d = new BigDecimal(value.toString());
        }
        return d != null ? d.toString() : null;
    }

    public static String stringControlValue(Object value) {
        return value != null ? value.toString() : null;
    }
}

