/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.StringCharacterIterator;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class NumberUtils {
    private static final int[] CRC16_TABLE = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    private NumberUtils() {
    }

    public static short unsigned(byte data) {
        return (short)(data & 0xFF);
    }

    public static short[] unsigned(byte[] data) {
        if (data == null) {
            return null;
        }
        short[] unsigned = new short[data.length];
        for (int i = 0; i < data.length; ++i) {
            unsigned[i] = (short)(data[i] & 0xFF);
        }
        return unsigned;
    }

    public static Number unsignedNumber(Number value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return Byte.toUnsignedInt(value.byteValue());
        }
        if (value instanceof Short) {
            return Short.toUnsignedInt(value.shortValue());
        }
        if (value instanceof Integer) {
            return Integer.toUnsignedLong(value.intValue());
        }
        return new BigInteger(Long.toUnsignedString(value.longValue()));
    }

    public static BigDecimal bigDecimalForNumber(Number value) {
        BigDecimal v = null;
        if (value == null) {
            return null;
        }
        v = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Long ? new BigDecimal(value.longValue()) : (value instanceof Integer || value instanceof Short ? new BigDecimal(value.intValue()) : (value instanceof Double ? BigDecimal.valueOf(value.doubleValue()) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : new BigDecimal(value.toString())))));
        return v;
    }

    public static BigInteger bigIntegerForNumber(Number value) {
        BigInteger v = null;
        if (value == null) {
            return null;
        }
        v = value instanceof BigInteger ? (BigInteger)value : (value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : new BigDecimal(value.toString()).toBigInteger());
        return v;
    }

    public static BigDecimal[] decimalArray(String ... nums) {
        BigDecimal[] vals = new BigDecimal[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            vals[i] = nums[i] != null ? new BigDecimal(nums[i]) : null;
        }
        return vals;
    }

    public static int crc16(byte[] data, int offset, int length) {
        int crc = 0;
        if (data != null && data.length >= offset + length) {
            for (int i = offset; i < data.length && i < offset + length; ++i) {
                byte b = data[i];
                crc = crc >>> 8 ^ CRC16_TABLE[(crc ^ b) & 0xFF];
            }
        }
        return crc;
    }

    public static BigInteger wholePartToInteger(BigDecimal decimal) {
        if (decimal == null) {
            return BigInteger.ZERO;
        }
        return decimal.setScale(0, decimal.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR).toBigInteger();
    }

    public static BigInteger fractionalPartToInteger(BigDecimal decimal) {
        if (decimal == null) {
            return BigInteger.ZERO;
        }
        return NumberUtils.fractionalPartToInteger(decimal, decimal.scale());
    }

    public static BigInteger fractionalPartToInteger(BigDecimal decimal, int maxScale) {
        if (decimal == null) {
            return BigInteger.ZERO;
        }
        return decimal.remainder(BigDecimal.ONE).movePointRight(Math.min(decimal.scale(), maxScale)).setScale(maxScale, decimal.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR).toBigInteger();
    }

    public static BigInteger fractionalPartScaledToInteger(BigDecimal decimal, int scale) {
        if (decimal == null) {
            return BigInteger.ZERO;
        }
        return decimal.subtract(new BigDecimal(NumberUtils.wholePartToInteger(decimal))).movePointRight(scale).setScale(0, decimal.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR).toBigInteger();
    }

    public static BigDecimal scaled(Number num, int scale) {
        if (num == null) {
            return null;
        }
        BigDecimal n = NumberUtils.bigDecimalForNumber(num);
        if (scale == 0) {
            return n;
        }
        if (scale < 0) {
            return n.movePointLeft(-scale);
        }
        return n.movePointRight(scale);
    }

    public static Number maximumDecimalScale(Number value, int maxDecimalScale) {
        return NumberUtils.round(value, maxDecimalScale, RoundingMode.HALF_UP);
    }

    public static Number multiplied(Number value, BigDecimal multiple) {
        if (value == null || multiple == null || BigDecimal.ONE.compareTo(multiple) == 0) {
            return value;
        }
        BigDecimal v = NumberUtils.bigDecimalForNumber(value);
        return v.multiply(multiple);
    }

    public static Number offset(Number value, BigDecimal offset) {
        if (value == null || offset == null || BigDecimal.ZERO.compareTo(offset) == 0) {
            return value;
        }
        BigDecimal v = NumberUtils.bigDecimalForNumber(value);
        return v.add(offset);
    }

    public static BigInteger bigIntegerForBitSet(BitSet bs) {
        BigInteger v = BigInteger.ZERO;
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0 && i != Integer.MAX_VALUE) {
                v = v.setBit(i);
                i = bs.nextSetBit(i + 1);
            }
        }
        return v;
    }

    public static BitSet bitSetForBigInteger(BigInteger value) {
        BitSet bs = new BitSet();
        if (value != null) {
            if (value.signum() < 0) {
                throw new IllegalArgumentException("Only non-negative values are allowed.");
            }
            int len = value.bitLength();
            for (int i = 0; i < len; ++i) {
                if (!value.testBit(i)) continue;
                bs.set(i);
            }
        }
        return bs;
    }

    public static int getAndIncrementWithWrap(AtomicInteger n, int restart) {
        int next;
        int result;
        while (!n.compareAndSet(result, next = (result = n.get()) < Integer.MAX_VALUE ? result + 1 : restart)) {
        }
        return result;
    }

    public static long getAndIncrementWithWrap(AtomicLong n, long restart) {
        long next;
        long result;
        while (!n.compareAndSet(result, next = (result = n.get()) < Long.MAX_VALUE ? result + 1L : restart)) {
        }
        return result;
    }

    public static Number parseNumber(String numberString, Class<? extends Number> numberType) {
        if (Integer.class.isAssignableFrom(numberType)) {
            return Integer.valueOf(numberString);
        }
        if (Float.class.isAssignableFrom(numberType)) {
            return Float.valueOf(numberString);
        }
        if (Long.class.isAssignableFrom(numberType)) {
            return Long.valueOf(numberString);
        }
        if (BigDecimal.class.isAssignableFrom(numberType)) {
            return new BigDecimal(numberString);
        }
        if (BigInteger.class.isAssignableFrom(numberType)) {
            return new BigInteger(numberString);
        }
        return Double.valueOf(numberString);
    }

    public static Number divide(Number dividend, Number divisor, Class<?> numberType) {
        if (Integer.class.isAssignableFrom(numberType)) {
            return dividend.intValue() / divisor.intValue();
        }
        if (Float.class.isAssignableFrom(numberType)) {
            return Float.valueOf(dividend.floatValue() / divisor.floatValue());
        }
        if (Long.class.isAssignableFrom(numberType)) {
            return dividend.longValue() / divisor.longValue();
        }
        if (dividend instanceof BigDecimal) {
            return ((BigDecimal)dividend).divide(NumberUtils.bigDecimalForNumber(divisor));
        }
        if (BigInteger.class.isAssignableFrom(numberType)) {
            return new BigDecimal((BigInteger)dividend).divide(NumberUtils.bigDecimalForNumber(divisor));
        }
        return dividend.doubleValue() / divisor.doubleValue();
    }

    public static Number subtract(Number start, Number offset) {
        if (start instanceof Integer) {
            return start.intValue() - offset.intValue();
        }
        if (start instanceof Float) {
            return Float.valueOf(start.floatValue() - offset.floatValue());
        }
        if (start instanceof Long) {
            return start.longValue() - offset.longValue();
        }
        if (start instanceof BigDecimal) {
            return ((BigDecimal)start).subtract(NumberUtils.bigDecimalForNumber(offset));
        }
        if (start instanceof BigInteger) {
            return ((BigInteger)start).subtract(NumberUtils.bigIntegerForNumber(offset));
        }
        return start.doubleValue() - offset.doubleValue();
    }

    public static Number multiply(Number a, Number b) {
        if (a instanceof Integer) {
            return a.intValue() * b.intValue();
        }
        if (a instanceof Float) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }
        if (a instanceof Long) {
            return a.longValue() * b.longValue();
        }
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).multiply(NumberUtils.bigDecimalForNumber(b));
        }
        if (a instanceof BigInteger) {
            return ((BigInteger)a).multiply(NumberUtils.bigIntegerForNumber(b));
        }
        return a.doubleValue() * b.doubleValue();
    }

    public static String humanReadableCount(long count) {
        if (-1000L < count && count < 1000L) {
            return count + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (count <= -999950L || count >= 999950L) {
            count /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)count / 1000.0, Character.valueOf(ci.current()));
    }

    public static Number min(Number n1, Number n2) {
        if (n1 == null && n2 == null) {
            return null;
        }
        if (n1 == null) {
            return n2;
        }
        if (n2 == null) {
            return n1;
        }
        if ((n1 instanceof Integer || n1 instanceof Short) && (n2 instanceof Integer || n2 instanceof Short)) {
            return Math.min(n1.intValue(), n2.intValue());
        }
        if (n1 instanceof Long && n2 instanceof Long) {
            return Math.min(n1.longValue(), n2.longValue());
        }
        if (n1 instanceof Float && n2 instanceof Float) {
            return Float.valueOf(Math.min(n1.floatValue(), n2.floatValue()));
        }
        if (n1 instanceof Double && n2 instanceof Double) {
            return Math.min(n1.doubleValue(), n2.doubleValue());
        }
        if (n1 instanceof BigInteger && n2 instanceof BigInteger) {
            return ((BigInteger)n1).min((BigInteger)n2);
        }
        return NumberUtils.bigDecimalForNumber(n1).min(NumberUtils.bigDecimalForNumber(n2));
    }

    public static Number max(Number n1, Number n2) {
        if (n1 == null && n2 == null) {
            return null;
        }
        if (n1 == null) {
            return n2;
        }
        if (n2 == null) {
            return n1;
        }
        if ((n1 instanceof Integer || n1 instanceof Short) && (n2 instanceof Integer || n2 instanceof Short)) {
            return Math.max(n1.intValue(), n2.intValue());
        }
        if (n1 instanceof Long && n2 instanceof Long) {
            return Math.max(n1.longValue(), n2.longValue());
        }
        if (n1 instanceof Float && n2 instanceof Float) {
            return Float.valueOf(Math.max(n1.floatValue(), n2.floatValue()));
        }
        if (n1 instanceof Double && n2 instanceof Double) {
            return Math.max(n1.doubleValue(), n2.doubleValue());
        }
        if (n1 instanceof BigInteger && n2 instanceof BigInteger) {
            return ((BigInteger)n1).max((BigInteger)n2);
        }
        return NumberUtils.bigDecimalForNumber(n1).max(NumberUtils.bigDecimalForNumber(n2));
    }

    public static Number down(Number n, Number significance) {
        return NumberUtils.mround(n, significance, RoundingMode.DOWN);
    }

    public static Number up(Number n, Number significance) {
        return NumberUtils.mround(n, significance, RoundingMode.UP);
    }

    public static Number floor(Number n, Number significance) {
        return NumberUtils.mround(n, significance, RoundingMode.FLOOR);
    }

    public static Number ceil(Number n, Number significance) {
        return NumberUtils.mround(n, significance, RoundingMode.CEILING);
    }

    public static Number mround(Number n, Number significance) {
        return NumberUtils.mround(n, significance, RoundingMode.HALF_UP);
    }

    public static Number mround(Number n, Number significance, RoundingMode mode) {
        BigDecimal d = NumberUtils.bigDecimalForNumber(n);
        BigDecimal s = NumberUtils.bigDecimalForNumber(significance);
        if (d == null || s == null) {
            return null;
        }
        if (mode == null) {
            mode = RoundingMode.HALF_UP;
        }
        if (BigDecimal.ONE.compareTo(s) == 0) {
            return d.setScale(0, mode);
        }
        return d.divide(s, mode).setScale(0, mode).multiply(s);
    }

    public static Number round(Number n, Number digits) {
        return NumberUtils.round(n, digits, RoundingMode.HALF_UP);
    }

    public static Number roundUp(Number n, Number digits) {
        return NumberUtils.round(n, digits, RoundingMode.UP);
    }

    public static Number roundDown(Number n, Number digits) {
        return NumberUtils.round(n, digits, RoundingMode.DOWN);
    }

    public static Number round(Number n, Number digits, RoundingMode mode) {
        BigDecimal d = NumberUtils.bigDecimalForNumber(n);
        if (d == null || digits == null) {
            return null;
        }
        int s = digits.intValue();
        if (s >= 0 && d.scale() > s) {
            if (mode == null) {
                mode = RoundingMode.HALF_UP;
            }
            d = d.setScale(s, mode);
        }
        return d;
    }

    public static Number narrow(Number n, int minBytePower) {
        Number res;
        if (n == null) {
            return null;
        }
        if (n instanceof BigInteger) {
            return NumberUtils.narrow((BigInteger)n, minBytePower);
        }
        if (n instanceof BigDecimal) {
            return NumberUtils.narrow((BigDecimal)n, minBytePower);
        }
        if (n instanceof Float || n instanceof Byte) {
            return n;
        }
        if (n instanceof Double) {
            float f = n.floatValue();
            if (Double.compare(f, n.doubleValue()) == 0) {
                return Float.valueOf(f);
            }
        } else {
            if (n instanceof Long) {
                if (minBytePower < 4) {
                    Number res2 = NumberUtils.narrow(NumberUtils.bigIntegerForNumber(n), minBytePower);
                    return n.equals(res2) ? (Number)n : (Number)res2;
                }
                return n;
            }
            if (n instanceof Integer) {
                if (minBytePower < 3) {
                    Number res3 = NumberUtils.narrow(NumberUtils.bigIntegerForNumber(n), minBytePower);
                    return n.equals(res3) ? (Number)n : (Number)res3;
                }
                return n;
            }
            if (n instanceof Short) {
                if (minBytePower < 2) {
                    Number res4 = NumberUtils.narrow(NumberUtils.bigIntegerForNumber(n), minBytePower);
                    return n.equals(res4) ? (Number)n : (Number)res4;
                }
                return n;
            }
        }
        return n.equals(res = NumberUtils.narrow(NumberUtils.bigDecimalForNumber(n), minBytePower)) ? (Number)n : (Number)res;
    }

    public static Number narrow(BigInteger n, int minBytePower) {
        if (n == null) {
            return null;
        }
        if (minBytePower < 1) {
            try {
                return n.byteValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (minBytePower < 2) {
            try {
                return n.shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (minBytePower < 3) {
            try {
                return n.intValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (minBytePower < 4) {
            try {
                return n.longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return n;
    }

    public static Number narrow(BigDecimal n, int minBytePower) {
        if (n == null) {
            return null;
        }
        if (minBytePower < 1) {
            try {
                return n.byteValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (minBytePower < 2) {
            try {
                return n.shortValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (minBytePower < 3) {
            try {
                return n.intValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                try {
                    return NumberUtils.floatValueExact(n);
                }
                catch (ArithmeticException arithmeticException2) {
                    // empty catch block
                }
            }
        }
        if (minBytePower < 4) {
            try {
                return n.longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                try {
                    return NumberUtils.doubleValueExact(n);
                }
                catch (ArithmeticException arithmeticException3) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public static Float floatValueExact(BigDecimal n) {
        if (n == null) {
            return null;
        }
        float result = n.floatValue();
        if (!Float.isNaN(result) && !Float.isInfinite(result) && new BigDecimal(String.valueOf(result)).compareTo(n) == 0) {
            return Float.valueOf(result);
        }
        throw new ArithmeticException("Overflow");
    }

    public static Double doubleValueExact(BigDecimal n) {
        if (n == null) {
            return null;
        }
        double result = n.doubleValue();
        if (!Double.isNaN(result) && !Double.isInfinite(result) && new BigDecimal(String.valueOf(result)).compareTo(n) == 0) {
            return result;
        }
        throw new ArithmeticException("Overflow");
    }
}

