/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchFilter {
    protected final Map<String, ?> filter;
    private final CompareOperator compareOp;
    private final LogicOperator logicOp;
    private static final Pattern TOKEN_PAT = Pattern.compile("\\s*(\\([&|!]|\\(|\\))\\s*");
    private static final Pattern COMP_PAT = Pattern.compile("(.+?)(=|<>|~=?|<=?|>=?|\\?|\\&\\&)(.+)");

    public SearchFilter(Map<String, ?> filter) {
        this(filter, CompareOperator.EQUAL, LogicOperator.AND);
    }

    public SearchFilter(Map<String, ?> filter, CompareOperator compareOp, LogicOperator logicOp) {
        this.filter = filter;
        this.compareOp = compareOp;
        this.logicOp = logicOp;
    }

    public SearchFilter(String key, Object value, CompareOperator compareOp) {
        this(Collections.singletonMap(key, value), compareOp, LogicOperator.AND);
    }

    public SearchFilter(Map<String, ?> filter, LogicOperator logicOp) {
        this(filter, CompareOperator.EQUAL, logicOp);
    }

    public void appendLDAPSearchFilter(StringBuilder buf) {
        if (this.filter == null) {
            return;
        }
        if (this.filter == null || this.filter.size() < 1) {
            return;
        }
        if (this.filter.size() > 1 || this.logicOp == LogicOperator.NOT) {
            buf.append('(').append(this.logicOp.toString());
            if (this.filter.size() > 1 && this.logicOp == LogicOperator.NOT) {
                buf.append("(&");
            }
        }
        for (Map.Entry<String, ?> me : this.filter.entrySet()) {
            String attributeName = me.getKey();
            Object value = me.getValue();
            if (value instanceof SearchFilter) {
                ((SearchFilter)value).appendLDAPSearchFilter(buf);
                continue;
            }
            buf.append('(');
            buf.append(attributeName);
            switch (this.compareOp) {
                case GREATER_THAN: {
                    buf.append(">");
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    buf.append(">=");
                    break;
                }
                case LESS_THAN: {
                    buf.append("<");
                    break;
                }
                case LESS_THAN_EQUAL: {
                    buf.append("<=");
                    break;
                }
                case PRESENT: {
                    buf.append("=*");
                    break;
                }
                case APPROX: {
                    buf.append("~=");
                    break;
                }
                default: {
                    buf.append("=");
                }
            }
            if (this.compareOp == CompareOperator.SUBSTRING) {
                if (value == null) {
                    buf.append("*");
                } else {
                    buf.append("*");
                    buf.append(value);
                    buf.append("*");
                }
            } else if (this.compareOp == CompareOperator.SUBSTRING_AT_START) {
                if (value != null) {
                    buf.append(value);
                }
                buf.append("*");
            } else if (this.compareOp != CompareOperator.PRESENT) {
                if (value == null) {
                    buf.append("*");
                } else if (value.getClass().isArray()) {
                    buf.append(Arrays.toString((Object[])value));
                } else {
                    buf.append(value);
                }
            }
            buf.append(')');
        }
        if (this.filter.size() > 1 || this.logicOp == LogicOperator.NOT) {
            buf.append(')');
            if (this.filter.size() > 1 && this.logicOp == LogicOperator.NOT) {
                buf.append(')');
            }
        }
    }

    public String asLDAPSearchFilterString() {
        StringBuilder buf = new StringBuilder();
        this.appendLDAPSearchFilter(buf);
        return buf.toString();
    }

    public String toString() {
        return this.asLDAPSearchFilterString();
    }

    public CompareOperator getCompareOperator() {
        return this.compareOp;
    }

    public LogicOperator getLogicOperator() {
        return this.logicOp;
    }

    public Map<String, ?> getFilter() {
        return this.filter;
    }

    private void addChild(SearchFilter n) {
        this.filter.put(UUID.randomUUID().toString(), n);
    }

    public boolean hasNestedFilter() {
        for (Object o : this.filter.values()) {
            if (!(o instanceof SearchFilter)) continue;
            return true;
        }
        return false;
    }

    public void walk(VisitorCallback callback) {
        SearchFilter.walkNode(this, null, callback);
    }

    private static boolean walkNode(SearchFilter node, SearchFilter parent, VisitorCallback callback) {
        if (node == null) {
            return false;
        }
        if (!callback.visit(node, parent)) {
            return false;
        }
        if (node.filter != null) {
            for (Map.Entry<String, ?> me : node.filter.entrySet()) {
                if (!(me.getValue() instanceof SearchFilter) || SearchFilter.walkNode((SearchFilter)me.getValue(), node, callback)) continue;
                return false;
            }
        }
        return true;
    }

    private static SearchFilter logicNode(char c) {
        return new SearchFilter(new LinkedHashMap(), LogicOperator.forKey(c));
    }

    private static SearchFilter compNode(String token) {
        Matcher m = COMP_PAT.matcher(token);
        if (m.matches()) {
            CompareOperator op = CompareOperator.forKey(m.group(2));
            String val = m.group(3);
            if (op == CompareOperator.EQUAL) {
                int len = val.length();
                char lastChar = val.charAt(len - 1);
                if (len > 2 && val.charAt(0) == '*' && lastChar == '*') {
                    op = CompareOperator.SUBSTRING;
                    val = val.substring(1, len - 1);
                } else if (len > 1 && lastChar == '*') {
                    op = CompareOperator.SUBSTRING_AT_START;
                    val = val.substring(0, len - 1);
                } else if (len == 1 && lastChar == '*') {
                    op = CompareOperator.PRESENT;
                    val = null;
                }
            }
            return new SearchFilter(m.group(1), val, op);
        }
        return null;
    }

    private static SearchFilter parseTokens(List<String> tokens, int start, int end) {
        SearchFilter topNode = null;
        SearchFilter node = null;
        String tok = null;
        LinkedList<SearchFilter> stack = new LinkedList<SearchFilter>();
        for (int i = start; i < end; ++i) {
            tok = tokens.get(i);
            if (tok.length() < 1) continue;
            char c = tok.charAt(0);
            if (c == '(') {
                if (tok.length() > 1) {
                    c = tok.charAt(1);
                    node = SearchFilter.logicNode(c);
                    if (topNode != null) {
                        topNode.addChild(node);
                    }
                    stack.push(node);
                    topNode = node;
                    continue;
                }
                if (i + 1 < end) {
                    node = SearchFilter.compNode(tokens.get(i + 1));
                }
                if (topNode == null) {
                    return node;
                }
                topNode.addChild(node);
                i += 2;
                continue;
            }
            if (c != ')') continue;
            if (stack.size() > 1) {
                stack.pop();
                topNode = (SearchFilter)stack.peek();
                continue;
            }
            return topNode;
        }
        return stack.size() > 0 ? (SearchFilter)stack.peek() : topNode;
    }

    private static List<String> parseTokens(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = TOKEN_PAT.matcher(s);
        int last = 0;
        while (m.find()) {
            if (m.start() > last) {
                tokens.add(s.substring(last, m.start()));
            }
            tokens.add(m.group(1));
            last = m.end();
        }
        return tokens;
    }

    public static SearchFilter forLDAPSearchFilterString(String s) {
        if (s == null) {
            return null;
        }
        List<String> tokens = SearchFilter.parseTokens(s);
        if (tokens.isEmpty()) {
            return null;
        }
        return SearchFilter.parseTokens(tokens, 0, tokens.size());
    }

    public static enum CompareOperator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_EQUAL,
        GREATER_THAN,
        GREATER_THAN_EQUAL,
        SUBSTRING,
        SUBSTRING_AT_START,
        PRESENT,
        APPROX,
        OVERLAP;


        public String toString() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case NOT_EQUAL: {
                    return "<>";
                }
                case LESS_THAN: {
                    return "<";
                }
                case LESS_THAN_EQUAL: {
                    return "<=";
                }
                case GREATER_THAN: {
                    return ">";
                }
                case GREATER_THAN_EQUAL: {
                    return ">=";
                }
                case SUBSTRING: {
                    return "**";
                }
                case SUBSTRING_AT_START: {
                    return "*";
                }
                case PRESENT: {
                    return "?";
                }
                case APPROX: {
                    return "~";
                }
                case OVERLAP: {
                    return "&&";
                }
            }
            throw new AssertionError((Object)this);
        }

        public static CompareOperator forKey(String key) {
            switch (key) {
                case "=": {
                    return EQUAL;
                }
                case "<>": {
                    return NOT_EQUAL;
                }
                case "<": {
                    return LESS_THAN;
                }
                case "<=": {
                    return LESS_THAN_EQUAL;
                }
                case ">": {
                    return GREATER_THAN;
                }
                case ">=": {
                    return GREATER_THAN_EQUAL;
                }
                case "**": {
                    return SUBSTRING;
                }
                case "*": {
                    return SUBSTRING_AT_START;
                }
                case "?": {
                    return PRESENT;
                }
                case "~": 
                case "~=": {
                    return APPROX;
                }
                case "&&": {
                    return OVERLAP;
                }
            }
            return null;
        }
    }

    public static enum LogicOperator {
        AND,
        OR,
        NOT;


        public String toString() {
            switch (this) {
                case AND: {
                    return "&";
                }
                case OR: {
                    return "|";
                }
                case NOT: {
                    return "!";
                }
            }
            throw new AssertionError((Object)this);
        }

        public static LogicOperator forKey(char key) {
            switch (key) {
                case '&': {
                    return AND;
                }
                case '|': {
                    return OR;
                }
                case '!': {
                    return NOT;
                }
            }
            return null;
        }
    }

    public static interface VisitorCallback {
        public boolean visit(SearchFilter var1, SearchFilter var2);
    }
}

