/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class WeakValueConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, WeakValue<V>> data;

    public WeakValueConcurrentHashMap() {
        this.data = new ConcurrentHashMap<K, WeakValue<V>>();
    }

    public WeakValueConcurrentHashMap(int initialCapacity) {
        this.data = new ConcurrentHashMap<K, WeakValue<V>>(initialCapacity);
    }

    public WeakValueConcurrentHashMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    public WeakValueConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    public WeakValueConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.data = new ConcurrentHashMap<K, WeakValue<V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value, "The value must not be null.");
        return this.data.containsValue(new WeakValue(value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public V get(Object key) {
        WeakValue v = (WeakValue)this.data.get(key);
        return v != null ? (V)v.get() : null;
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(value, "The value must not be null.");
        WeakValue v = this.data.put(key, new WeakValue(value));
        return v != null ? (V)v.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> me : m.entrySet()) {
            this.data.put(me.getKey(), new WeakValue(me.getValue()));
        }
    }

    @Override
    public V remove(Object key) {
        WeakValue v = (WeakValue)this.data.remove(key);
        return v != null ? (V)v.get() : null;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(value, "The value must not be null.");
        WeakReference v = this.data.putIfAbsent(key, new WeakValue(value));
        return v != null ? (V)v.get() : null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(value, "The value must not be null.");
        return this.data.remove(key, new WeakValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Objects.requireNonNull(oldValue, "The newValue must not be null.");
        Objects.requireNonNull(newValue, "The newValue must not be null.");
        return this.data.replace(key, new WeakValue(oldValue), new WeakValue(newValue));
    }

    @Override
    public V replace(K key, V value) {
        Objects.requireNonNull(value, "The value must not be null.");
        WeakValue v = this.data.replace(key, new WeakValue(value));
        return v != null ? (V)v.get() : null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this.data.entrySet());
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction, "A mapping function is required.");
        WeakValue r = this.data.computeIfAbsent(key, k -> {
            Object mapped = mappingFunction.apply((Object)k);
            return mapped != null ? new WeakValue(mapped) : null;
        });
        return r != null ? (V)r.get() : null;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "A remapping function is required.");
        WeakValue r = this.data.computeIfPresent(key, (k, v) -> {
            Object old = v != null ? (Object)v.get() : null;
            Object mapped = remappingFunction.apply((Object)k, (Object)old);
            return mapped != null ? new WeakValue(mapped) : null;
        });
        return r != null ? (V)r.get() : null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "A remapping function is required.");
        WeakValue r = this.data.compute(key, (k, v) -> {
            Object old = v != null ? (Object)v.get() : null;
            Object mapped = remappingFunction.apply((Object)k, (Object)old);
            return mapped != null ? new WeakValue(mapped) : null;
        });
        return r != null ? (V)r.get() : null;
    }

    private static class WeakValue<T>
    extends WeakReference<T> {
        private WeakValue(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
        }

        private WeakValue(T referent) {
            super(referent);
        }

        public int hashCode() {
            Object v = this.get();
            return v != null ? v.hashCode() : super.hashCode();
        }

        public boolean equals(Object obj) {
            WeakValue o = (WeakValue)obj;
            Object v = this.get();
            return v != null ? v.equals(o.get()) : super.equals(obj);
        }
    }

    private static final class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, WeakValue<V>>> set;

        private EntrySet(Set<Map.Entry<K, WeakValue<V>>> set) {
            this.set = set;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.set.iterator());
        }

        @Override
        public int size() {
            return this.set.size();
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, WeakValue<V>>> itr;

            private EntryIterator(Iterator<Map.Entry<K, WeakValue<V>>> itr) {
                this.itr = itr;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry e = this.itr.next();
                return e != null ? new WeakEntry(e) : null;
            }
        }

        private final class WeakEntry
        implements Map.Entry<K, V> {
            private final Map.Entry<K, WeakValue<V>> e;

            private WeakEntry(Map.Entry<K, WeakValue<V>> e) {
                this.e = e;
            }

            @Override
            public K getKey() {
                return this.e.getKey();
            }

            @Override
            public V getValue() {
                WeakValue v = this.e.getValue();
                return v != null ? (Object)v.get() : null;
            }

            @Override
            public V setValue(V value) {
                WeakValue v = this.e.setValue(new WeakValue(value));
                return v != null ? (Object)v.get() : null;
            }
        }
    }
}

