/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import net.solarnetwork.codec.IndexedField;
import net.solarnetwork.codec.JsonDateUtils;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.InstructionStatus;

public enum BasicInstructionStatusField implements IndexedField
{
    InstructionId(0, "instructionId"),
    StatusDate(1, "statusDate"),
    InstructionState(2, "state"),
    ResultParameters(3, "resultParameters");

    public static final Map<String, BasicInstructionStatusField> FIELD_MAP;
    private final int index;
    private final String fieldName;

    private BasicInstructionStatusField(int index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object parseValue(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (this) {
            case InstructionId: {
                parser.nextToken();
                return parser.getLongValue();
            }
            case InstructionState: {
                try {
                    return InstructionStatus.InstructionState.valueOf(parser.nextTextValue());
                }
                catch (Exception e) {
                    return InstructionStatus.InstructionState.Unknown;
                }
            }
            case StatusDate: {
                parser.nextToken();
                return JsonDateUtils.InstantDeserializer.INSTANCE.deserialize(parser, ctxt);
            }
            case ResultParameters: {
                return JsonUtils.parseSimpleMap(parser);
            }
        }
        return null;
    }

    @Override
    public void writeValue(JsonGenerator generator, SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        switch (this) {
            case InstructionId: {
                generator.writeNumberField(this.fieldName, ((Number)value).longValue());
                break;
            }
            case InstructionState: {
                generator.writeStringField(this.fieldName, value.toString());
                break;
            }
            case StatusDate: {
                generator.writeFieldName(this.fieldName);
                JsonDateUtils.InstantSerializer.INSTANCE.serialize((Object)((Instant)value), generator, provider);
                break;
            }
            case ResultParameters: {
                generator.writeFieldName(this.fieldName);
                JsonUtils.writeSimpleMap(generator, (Map)value);
                break;
            }
        }
    }

    static {
        FIELD_MAP = IndexedField.fieldMap(BasicInstructionStatusField.class);
    }
}

