/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import net.solarnetwork.codec.BasicObjectDatumStreamDataSetSerializer;
import net.solarnetwork.codec.BasicObjectDatumStreamMetadataDeserializer;
import net.solarnetwork.domain.datum.BasicAggregateStreamDatum;
import net.solarnetwork.domain.datum.BasicObjectDatumStreamDataSet;
import net.solarnetwork.domain.datum.BasicStreamDatum;
import net.solarnetwork.domain.datum.DatumProperties;
import net.solarnetwork.domain.datum.DatumPropertiesStatistics;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.DatumStreamMetadata;
import net.solarnetwork.domain.datum.ObjectDatumStreamDataSet;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;
import net.solarnetwork.domain.datum.StreamDatum;

public class BasicObjectDatumStreamDataSetDeserializer
extends StdScalarDeserializer<ObjectDatumStreamDataSet<StreamDatum>> {
    private static final long serialVersionUID = 3809268939568086603L;
    public static final BasicObjectDatumStreamDataSetDeserializer INSTANCE = new BasicObjectDatumStreamDataSetDeserializer();

    public BasicObjectDatumStreamDataSetDeserializer() {
        super(ObjectDatumStreamDataSet.class);
    }

    public ObjectDatumStreamDataSet<StreamDatum> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (p.isExpectedStartObjectToken()) {
            Integer returnedResultCount = null;
            Integer startingOffset = null;
            Long totalResultCount = null;
            ArrayList<ObjectDatumStreamMetadata> metadatas = new ArrayList<ObjectDatumStreamMetadata>(4);
            ArrayList<BasicStreamDatum> data = new ArrayList<BasicStreamDatum>();
            while ((t = p.nextToken()) != JsonToken.END_OBJECT) {
                if (BasicObjectDatumStreamDataSetSerializer.RETURNED_RESULT_COUNT_FIELD_NAME.toString().equals(p.currentName())) {
                    returnedResultCount = p.getIntValue();
                    continue;
                }
                if (BasicObjectDatumStreamDataSetSerializer.STARTING_OFFSET_FIELD_NAME.toString().equals(p.currentName())) {
                    startingOffset = p.getIntValue();
                    continue;
                }
                if (BasicObjectDatumStreamDataSetSerializer.TOTAL_RESULT_COUNT_FIELD_NAME.toString().equals(p.currentName())) {
                    totalResultCount = p.getLongValue();
                    continue;
                }
                if (BasicObjectDatumStreamDataSetSerializer.META_FIELD_NAME.toString().equals(p.currentName())) {
                    if (p.nextToken() != JsonToken.START_ARRAY) continue;
                    t = p.nextToken();
                    while (t != null && t != JsonToken.END_ARRAY) {
                        ObjectDatumStreamMetadata meta = BasicObjectDatumStreamMetadataDeserializer.INSTANCE.deserialize(p, ctxt);
                        metadatas.add(meta);
                        t = p.nextToken();
                    }
                    continue;
                }
                if (!BasicObjectDatumStreamDataSetSerializer.DATA_FIELD_NAME.toString().equals(p.currentName()) || p.nextToken() != JsonToken.START_ARRAY) continue;
                while (p.nextToken() == JsonToken.START_ARRAY) {
                    int i = -2;
                    DatumStreamMetadata meta = null;
                    long ts = 0L;
                    long tsEnd = -1L;
                    String[] iNames = null;
                    String[] aNames = null;
                    String[] sNames = null;
                    int iLen = 0;
                    int aLen = 0;
                    int sLen = 0;
                    int aStart = 0;
                    int sStart = 0;
                    int tStart = 0;
                    BigDecimal[] iData = null;
                    BigDecimal[] aData = null;
                    String[] sData = null;
                    ArrayList<String> tags = null;
                    BigDecimal[][] iStats = null;
                    BigDecimal[][] aStats = null;
                    t = p.nextToken();
                    while (t != null && t != JsonToken.END_ARRAY) {
                        int j;
                        if (i == -2) {
                            int idx = p.getIntValue();
                            if (idx >= metadatas.size()) {
                                throw new JsonParseException(p, String.format("Missing metadata index %d", idx));
                            }
                            meta = (ObjectDatumStreamMetadata)metadatas.get(idx);
                            iNames = meta.propertyNamesForType(DatumSamplesType.Instantaneous);
                            aNames = meta.propertyNamesForType(DatumSamplesType.Accumulating);
                            sNames = meta.propertyNamesForType(DatumSamplesType.Status);
                            iLen = iNames != null ? iNames.length : 0;
                            aLen = aNames != null ? aNames.length : 0;
                            sLen = sNames != null ? sNames.length : 0;
                            aStart = iLen;
                            sStart = aStart + aLen;
                            tStart = sStart + sLen;
                            iData = iLen > 0 ? new BigDecimal[iLen] : null;
                            aData = aLen > 0 ? new BigDecimal[aLen] : null;
                            sData = sLen > 0 ? new String[sLen] : null;
                        } else if (i == -1) {
                            if (t == JsonToken.START_ARRAY) {
                                t = p.nextToken();
                                ts = p.getLongValue();
                                t = p.nextToken();
                                tsEnd = t != JsonToken.VALUE_NULL ? p.getLongValue() : 0L;
                                t = p.nextToken();
                                iStats = new BigDecimal[iLen][];
                                aStats = new BigDecimal[aLen][];
                            } else {
                                ts = p.getLongValue();
                            }
                        } else if (iLen > 0 && i < aStart) {
                            if (t == JsonToken.START_ARRAY) {
                                BigDecimal[] stats;
                                iStats[i] = stats = new BigDecimal[3];
                                j = -1;
                                t = p.nextToken();
                                while (t != null && t != JsonToken.END_ARRAY) {
                                    if (j < 0) {
                                        iData[i] = t == JsonToken.VALUE_NULL ? null : p.getDecimalValue();
                                    } else if (j < 3) {
                                        stats[j] = t == JsonToken.VALUE_NULL ? null : p.getDecimalValue();
                                    }
                                    t = p.nextToken();
                                    ++j;
                                }
                            } else {
                                iData[i] = t == JsonToken.VALUE_NULL ? null : p.getDecimalValue();
                            }
                        } else if (aLen > 0 && i < sStart) {
                            if (t == JsonToken.START_ARRAY) {
                                BigDecimal[] stats;
                                aStats[i - aStart] = stats = new BigDecimal[2];
                                j = -1;
                                t = p.nextToken();
                                while (t != null && t != JsonToken.END_ARRAY) {
                                    if (j < 0) {
                                        aData[i - aStart] = t == JsonToken.VALUE_NULL ? null : p.getDecimalValue();
                                    } else if (j < 2) {
                                        stats[j] = t == JsonToken.VALUE_NULL ? null : p.getDecimalValue();
                                    }
                                    t = p.nextToken();
                                    ++j;
                                }
                            } else {
                                aData[i - aStart] = t == JsonToken.VALUE_NULL ? null : p.getDecimalValue();
                            }
                        } else if (sLen > 0 && i < tStart) {
                            sData[i - sStart] = t == JsonToken.VALUE_NULL ? null : p.getText();
                        } else if (t == JsonToken.VALUE_STRING) {
                            if (tags == null) {
                                tags = new ArrayList<String>(4);
                            }
                            tags.add(p.getText());
                        }
                        t = p.nextToken();
                        ++i;
                    }
                    if (tsEnd > -1L) {
                        data.add(new BasicAggregateStreamDatum(meta.getStreamId(), Instant.ofEpochMilli(ts), DatumProperties.propertiesOf(iData, aData, sData, tags != null ? tags.toArray(new String[tags.size()]) : null), tsEnd > 0L ? Instant.ofEpochMilli(tsEnd) : null, DatumPropertiesStatistics.statisticsOf(iStats, aStats)));
                        continue;
                    }
                    data.add(new BasicStreamDatum(meta.getStreamId(), Instant.ofEpochMilli(ts), DatumProperties.propertiesOf(iData, aData, sData, tags != null ? tags.toArray(new String[tags.size()]) : null)));
                }
            }
            return BasicObjectDatumStreamDataSet.dataSet(metadatas, data, totalResultCount, startingOffset, returnedResultCount);
        }
        throw new JsonParseException(p, "Unable to parse StreamDatum (not an array)");
    }
}

