/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import net.solarnetwork.codec.BasicObjectDatumStreamMetadataSerializer;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.datum.DatumProperties;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.ObjectDatumStreamDataSet;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;
import net.solarnetwork.domain.datum.StreamDatum;

public class BasicObjectDatumStreamDataSetSerializer
extends StdScalarSerializer<ObjectDatumStreamDataSet<? extends StreamDatum>>
implements Serializable {
    private static final long serialVersionUID = -4226762305023708915L;
    public static final BasicObjectDatumStreamDataSetSerializer INSTANCE = new BasicObjectDatumStreamDataSetSerializer();
    public static final SerializedString META_FIELD_NAME = new SerializedString("meta");
    public static final SerializedString DATA_FIELD_NAME = new SerializedString("data");
    public static final SerializedString RETURNED_RESULT_COUNT_FIELD_NAME = new SerializedString("returnedResultCount");
    public static final SerializedString STARTING_OFFSET_FIELD_NAME = new SerializedString("startingOffset");
    public static final SerializedString TOTAL_RESULT_COUNT_FIELD_NAME = new SerializedString("totalResultCount");

    public BasicObjectDatumStreamDataSetSerializer() {
        super(ObjectDatumStreamDataSet.class, false);
    }

    public void serialize(ObjectDatumStreamDataSet<? extends StreamDatum> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Collection<UUID> streamIds = value.metadataStreamIds();
        HashMap<UUID, Integer> metaIndexMap = new HashMap<UUID, Integer>(streamIds.size());
        Iterator itr = value.iterator();
        int count = (value.getReturnedResultCount() != null ? 1 : 0) + (value.getStartingOffset() != null ? 1 : 0) + (value.getTotalResultCount() != null ? 1 : 0) + (streamIds != null && !streamIds.isEmpty() ? 1 : 0) + (itr.hasNext() ? 1 : 0);
        gen.writeStartObject(value, count);
        if (value.getReturnedResultCount() != null) {
            gen.writeFieldName((SerializableString)RETURNED_RESULT_COUNT_FIELD_NAME);
            gen.writeNumber(value.getReturnedResultCount().intValue());
        }
        if (value.getStartingOffset() != null) {
            gen.writeFieldName((SerializableString)STARTING_OFFSET_FIELD_NAME);
            gen.writeNumber(value.getStartingOffset().intValue());
        }
        if (value.getTotalResultCount() != null) {
            gen.writeFieldName((SerializableString)TOTAL_RESULT_COUNT_FIELD_NAME);
            gen.writeNumber(value.getTotalResultCount().longValue());
        }
        int i = 0;
        if (streamIds != null && !streamIds.isEmpty()) {
            gen.writeFieldName((SerializableString)META_FIELD_NAME);
            gen.writeStartArray(streamIds.size());
            for (UUID streamId : streamIds) {
                metaIndexMap.put(streamId, i);
                BasicObjectDatumStreamMetadataSerializer.INSTANCE.serialize(value.metadataForStreamId(streamId), gen, provider);
                ++i;
            }
            gen.writeEndArray();
        }
        if (itr.hasNext()) {
            gen.writeFieldName((SerializableString)DATA_FIELD_NAME);
            gen.writeStartArray();
            i = 0;
            while (itr.hasNext()) {
                StreamDatum d = (StreamDatum)itr.next();
                ObjectDatumStreamMetadata meta = value.metadataForStreamId(d.getStreamId());
                if (meta == null) {
                    throw new JsonMappingException((Closeable)gen, String.format("Metadata for stream %s not available for datum %d", d.getStreamId(), i));
                }
                String[] iNames = meta.propertyNamesForType(DatumSamplesType.Instantaneous);
                String[] aNames = meta.propertyNamesForType(DatumSamplesType.Accumulating);
                String[] sNames = meta.propertyNamesForType(DatumSamplesType.Status);
                int iLen = iNames != null ? iNames.length : 0;
                int aLen = aNames != null ? aNames.length : 0;
                int sLen = sNames != null ? sNames.length : 0;
                int baseLen = 1 + iLen + aLen + sLen;
                DatumProperties p = d.getProperties();
                long ts = d.getTimestamp() != null ? d.getTimestamp().toEpochMilli() : 0L;
                int tLen = p != null ? p.getTagsLength() : 0;
                int totalLen = 1 + baseLen + tLen;
                gen.writeStartArray(totalLen);
                gen.writeNumber(((Integer)metaIndexMap.get(d.getStreamId())).intValue());
                gen.writeNumber(ts);
                if (p != null) {
                    JsonUtils.writeDecimalArrayValues(gen, p.getInstantaneous(), iLen);
                    JsonUtils.writeDecimalArrayValues(gen, p.getAccumulating(), aLen);
                    JsonUtils.writeStringArrayValues(gen, p.getStatus(), sLen);
                    JsonUtils.writeStringArrayValues(gen, p.getTags(), tLen);
                }
                gen.writeEndArray();
                ++i;
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

