/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.datum.DatumProperties;
import net.solarnetwork.domain.datum.StreamDatum;

public class BasicStreamDatumArraySerializer
extends StdScalarSerializer<StreamDatum>
implements Serializable {
    private static final long serialVersionUID = -4548263284532264499L;
    public static final BasicStreamDatumArraySerializer INSTANCE = new BasicStreamDatumArraySerializer();

    public BasicStreamDatumArraySerializer() {
        super(StreamDatum.class);
    }

    public void serialize(StreamDatum datum, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
        generator.writeStartArray(7);
        if (datum.getTimestamp() != null) {
            generator.writeNumber(datum.getTimestamp().toEpochMilli());
        } else {
            generator.writeNull();
        }
        UUID streamId = datum.getStreamId();
        if (streamId != null) {
            generator.writeNumber(streamId.getMostSignificantBits());
            generator.writeNumber(streamId.getLeastSignificantBits());
        } else {
            generator.writeNull();
            generator.writeNull();
        }
        DatumProperties props = datum.getProperties();
        JsonUtils.writeDecimalArray(generator, props.getInstantaneous());
        JsonUtils.writeDecimalArray(generator, props.getAccumulating());
        JsonUtils.writeStringArray(generator, props.getStatus());
        JsonUtils.writeStringArray(generator, props.getTags());
        generator.writeEndArray();
    }
}

