/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.solarnetwork.codec.BasicGeneralDatumDeserializer;
import net.solarnetwork.codec.BasicGeneralDatumSerializer;
import net.solarnetwork.codec.BasicInstructionDeserializer;
import net.solarnetwork.codec.BasicInstructionSerializer;
import net.solarnetwork.codec.BasicInstructionStatusDeserializer;
import net.solarnetwork.codec.BasicInstructionStatusSerializer;
import net.solarnetwork.codec.BasicLocationDeserializer;
import net.solarnetwork.codec.BasicLocationSerializer;
import net.solarnetwork.codec.BasicObjectDatumStreamDataSetDeserializer;
import net.solarnetwork.codec.BasicObjectDatumStreamDataSetSerializer;
import net.solarnetwork.codec.BasicObjectDatumStreamMetadataDeserializer;
import net.solarnetwork.codec.BasicObjectDatumStreamMetadataIdDeserializer;
import net.solarnetwork.codec.BasicObjectDatumStreamMetadataIdSerializer;
import net.solarnetwork.codec.BasicObjectDatumStreamMetadataSerializer;
import net.solarnetwork.codec.BasicStreamDatumArrayDeserializer;
import net.solarnetwork.codec.BasicStreamDatumArraySerializer;
import net.solarnetwork.codec.IndexedField;
import net.solarnetwork.codec.ObjectMapperFactoryBean;
import net.solarnetwork.domain.Bitmaskable;
import net.solarnetwork.domain.Instruction;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.domain.Location;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import net.solarnetwork.domain.datum.ObjectDatumStreamDataSet;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadataId;
import net.solarnetwork.domain.datum.StreamDatum;
import net.solarnetwork.util.Half;
import net.solarnetwork.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    public static final TypeReference<LinkedHashMap<String, Object>> STRING_MAP_TYPE = new StringMapTypeReference();
    public static final Module JAVA_TIME_MODULE = JsonUtils.createOptionalModule("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", m -> {
        m.addSerializer(Instant.class, JsonUtils.loadOptionalSerializerInstance("net.solarnetwork.codec.JsonDateUtils$InstantSerializer"));
        m.addSerializer(ZonedDateTime.class, JsonUtils.loadOptionalSerializerInstance("net.solarnetwork.codec.JsonDateUtils$ZonedDateTimeSerializer"));
        m.addSerializer(LocalDateTime.class, JsonUtils.loadOptionalSerializerInstance("net.solarnetwork.codec.JsonDateUtils$LocalDateTimeSerializer"));
        m.addDeserializer(Instant.class, JsonUtils.loadOptionalDeserializerInstance("net.solarnetwork.codec.JsonDateUtils$InstantDeserializer"));
        m.addDeserializer(ZonedDateTime.class, JsonUtils.loadOptionalDeserializerInstance("net.solarnetwork.codec.JsonDateUtils$ZonedDateTimeDeserializer"));
        m.addDeserializer(LocalDateTime.class, JsonUtils.loadOptionalDeserializerInstance("net.solarnetwork.codec.JsonDateUtils$LocalDateTimeDeserializer"));
    });
    public static final Module JAVA_TIMESTAMP_MODULE = JsonUtils.createOptionalModule("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", m -> {
        m.addSerializer(LocalDateTime.class, JsonUtils.loadOptionalSerializerInstance("net.solarnetwork.codec.JsonDateUtils$LocalDateTimeSerializer"));
        m.addDeserializer(Instant.class, JsonUtils.loadOptionalDeserializerInstance("net.solarnetwork.codec.JsonDateUtils$InstantDeserializer"));
        m.addDeserializer(ZonedDateTime.class, JsonUtils.loadOptionalDeserializerInstance("net.solarnetwork.codec.JsonDateUtils$ZonedDateTimeDeserializer"));
        m.addDeserializer(LocalDateTime.class, JsonUtils.loadOptionalDeserializerInstance("net.solarnetwork.codec.JsonDateUtils$LocalDateTimeDeserializer"));
    });
    public static final Module DATUM_MODULE;
    private static final ObjectMapper OBJECT_MAPPER;

    private static final ObjectMapper createObjectMapper() {
        return JsonUtils.createObjectMapper(null, JAVA_TIME_MODULE);
    }

    private static final ObjectMapper createObjectMapper(JsonFactory jsonFactory) {
        return JsonUtils.createObjectMapper(jsonFactory, JAVA_TIME_MODULE);
    }

    public static final ObjectMapper createObjectMapper(JsonFactory jsonFactory, Module ... modules) {
        ObjectMapperFactoryBean factory = new ObjectMapperFactoryBean();
        if (jsonFactory != null) {
            factory.setJsonFactory(jsonFactory);
        }
        factory.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        factory.setFeaturesToDisable(Arrays.asList(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS));
        factory.setFeaturesToEnable(Arrays.asList(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS));
        if (modules != null) {
            for (Module module : modules) {
                JsonUtils.registerOptionalModule(factory, module);
            }
        }
        try {
            ObjectMapper mapper = factory.getObject();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS'Z'"));
            return mapper;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SimpleModule createOptionalModule(String className, Consumer<SimpleModule> configuror) {
        try {
            Class<SimpleModule> clazz = JsonUtils.class.getClassLoader().loadClass(className).asSubclass(SimpleModule.class);
            SimpleModule m = clazz.newInstance();
            if (configuror != null) {
                configuror.accept(m);
            }
            return m;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.info("Optional JSON module {} not available ({})", (Object)className, (Object)e.toString());
            return null;
        }
    }

    private static void registerOptionalModule(ObjectMapperFactoryBean factory, Module m) {
        if (m != null) {
            List<Module> modules = factory.getModules();
            if (modules == null) {
                modules = new ArrayList<Module>(2);
            }
            modules.add(m);
            factory.setModules(modules);
        }
    }

    private static final <T> JsonSerializer<T> loadOptionalSerializerInstance(String className) {
        try {
            Class<JsonSerializer> clazz = JsonUtils.class.getClassLoader().loadClass(className).asSubclass(JsonSerializer.class);
            Field f = clazz.getDeclaredField("INSTANCE");
            return (JsonSerializer)f.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            LOG.info("Optional JSON serializer {} not available ({})", (Object)className, (Object)e.toString());
            return null;
        }
    }

    private static final <T> JsonDeserializer<T> loadOptionalDeserializerInstance(String className) {
        try {
            Class<JsonDeserializer> clazz = JsonUtils.class.getClassLoader().loadClass(className).asSubclass(JsonDeserializer.class);
            Field f = clazz.getDeclaredField("INSTANCE");
            return (JsonDeserializer)f.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            LOG.info("Optional JSON deserializer {} not available ({})", (Object)className, (Object)e.toString());
            return null;
        }
    }

    private JsonUtils() {
    }

    public static String getJSONString(Object o, String defaultValue) {
        String result = defaultValue;
        if (o != null) {
            try {
                return OBJECT_MAPPER.writeValueAsString(o);
            }
            catch (Exception e) {
                LOG.warn("Exception marshalling {} to JSON", o, (Object)e);
            }
        }
        return result;
    }

    public static <T> T getObjectFromJSON(String json, Class<T> clazz) {
        Object result = null;
        if (json != null) {
            try {
                result = OBJECT_MAPPER.readValue(json, clazz);
            }
            catch (Exception e) {
                LOG.warn("Exception deserialzing json {}", (Object)json, (Object)e);
            }
        }
        return (T)result;
    }

    public static Map<String, Object> getStringMap(String json) {
        if (json == null || json.length() < 1) {
            return null;
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(json, STRING_MAP_TYPE);
        }
        catch (Exception e) {
            LOG.warn("Exception deserialzing JSON {} to Map<String, Object>", (Object)json, (Object)e);
            return null;
        }
    }

    public static Map<String, Object> getStringMapFromTree(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(OBJECT_MAPPER.treeAsTokens((TreeNode)node), STRING_MAP_TYPE);
        }
        catch (Exception e) {
            LOG.warn("Exception deserialzing JSON node {} to Map<String, Object>", (Object)node, (Object)e);
            return null;
        }
    }

    public static JsonNode getTreeFromObject(Object o) {
        if (o == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.valueToTree(o);
        }
        catch (Exception e) {
            LOG.warn("Exception serialzing object {} to JsonNode", o, (Object)e);
            return null;
        }
    }

    public static Map<String, Object> getStringMapFromObject(Object o) {
        return JsonUtils.getStringMapFromTree(JsonUtils.getTreeFromObject(o));
    }

    public static void writeMetadata(JsonGenerator generator, GeneralDatumMetadata meta) throws IOException {
        Set<String> t;
        Map<String, Map<String, Object>> pm;
        if (meta == null) {
            return;
        }
        Map<String, Object> m = meta.getM();
        if (m != null) {
            generator.writeObjectField("m", m);
        }
        if ((pm = meta.getPm()) != null) {
            generator.writeObjectField("pm", pm);
        }
        if ((t = meta.getT()) != null) {
            generator.writeArrayFieldStart("t");
            for (String tag : t) {
                generator.writeString(tag);
            }
            generator.writeEndArray();
        }
    }

    public static BigDecimal parseBigDecimalAttribute(JsonNode node, String key) {
        JsonNode attrNode;
        BigDecimal num = null;
        if (node != null && (attrNode = node.get(key)) != null && !attrNode.isNull()) {
            String txt = attrNode.asText();
            if (txt.indexOf(46) < 0) {
                txt = txt + ".0";
            }
            try {
                num = new BigDecimal(txt);
            }
            catch (NumberFormatException e) {
                LOG.debug("Error parsing decimal attribute [{}] value [{}]: {}", new Object[]{key, attrNode, e.getMessage()});
            }
        }
        return num;
    }

    public static <T> T parseDateAttribute(TreeNode node, String key, DateTimeFormatter dateFormat, TemporalQuery<T> query) {
        TreeNode attrNode;
        T result = null;
        if (node != null && (attrNode = node.get(key)) instanceof JsonNode && !((JsonNode)attrNode).isNull()) {
            try {
                String dateString = ((JsonNode)attrNode).asText();
                dateString = dateString.replaceAll("(?i)midnight", "12:00am");
                dateString = dateString.replaceAll("(?i)noon", "12:00pm");
                result = dateFormat.parse((CharSequence)dateString, query);
            }
            catch (DateTimeParseException e) {
                LOG.debug("Error parsing date attribute [{}] value [{}] using pattern {}: {}", new Object[]{key, attrNode, dateFormat, e.getMessage()});
            }
        }
        return result;
    }

    public static Integer parseIntegerAttribute(JsonNode node, String key) {
        JsonNode attrNode;
        Integer num = null;
        if (node != null && (attrNode = node.get(key)) != null && !attrNode.isNull()) {
            if (attrNode.isIntegralNumber()) {
                num = attrNode.asInt();
            } else {
                String s = attrNode.asText();
                if (s != null) {
                    s = s.trim();
                }
                try {
                    num = Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    LOG.debug("Error parsing integer attribute [{}] value [{}]: {}", new Object[]{key, attrNode, e.getMessage()});
                }
            }
        }
        return num;
    }

    public static Long parseLongAttribute(JsonNode node, String key) {
        JsonNode attrNode;
        Long num = null;
        if (node != null && (attrNode = node.get(key)) != null && !attrNode.isNull()) {
            if (attrNode.isIntegralNumber()) {
                num = attrNode.asLong();
            } else {
                try {
                    num = Long.valueOf(attrNode.asText());
                }
                catch (NumberFormatException e) {
                    LOG.debug("Error parsing long attribute [{}] value [{}]: {}", new Object[]{key, attrNode, e.getMessage()});
                }
            }
        }
        return num;
    }

    public static String parseStringAttribute(JsonNode node, String key) {
        JsonNode attrNode;
        String s = null;
        if (node != null && (attrNode = node.get(key)) != null && !attrNode.isNull()) {
            s = attrNode.asText();
        }
        return s;
    }

    public static ObjectMapper newObjectMapper() {
        return OBJECT_MAPPER.copy();
    }

    public static ObjectMapper newDatumObjectMapper() {
        ObjectMapper mapper = OBJECT_MAPPER.copy();
        mapper.registerModule(DATUM_MODULE);
        return mapper;
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        return JsonUtils.createObjectMapper(jsonFactory);
    }

    public static ObjectMapper newDatumObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper mapper = JsonUtils.newObjectMapper(jsonFactory);
        mapper.registerModule(DATUM_MODULE);
        return mapper;
    }

    public static String[] parseStringArray(JsonParser p) throws IOException, JsonProcessingException {
        JsonToken t = p.nextToken();
        if (p.isExpectedStartArrayToken()) {
            ArrayList<String> l = new ArrayList<String>(8);
            do {
                if ((t = p.nextToken()) == null) continue;
                if (t.isScalarValue()) {
                    l.add(p.getValueAsString());
                    continue;
                }
                if (t == JsonToken.END_ARRAY) continue;
                l.add(null);
            } while (t != null && t != JsonToken.END_ARRAY);
            return l.toArray(new String[l.size()]);
        }
        return null;
    }

    public static void writeStringArray(JsonGenerator generator, String[] array) throws IOException, JsonGenerationException {
        if (array != null && array.length > 0) {
            generator.writeStartArray((Object)array, array.length);
            for (int i = 0; i < array.length; ++i) {
                String s = array[i];
                if (s != null) {
                    generator.writeString(array[i]);
                    continue;
                }
                generator.writeNull();
            }
            generator.writeEndArray();
        } else {
            generator.writeNull();
        }
    }

    public static void writeStringArrayField(JsonGenerator generator, String fieldName, String[] array) throws IOException, JsonGenerationException {
        if (array != null && array.length > 0) {
            generator.writeFieldName(fieldName);
            JsonUtils.writeStringArray(generator, array);
        }
    }

    public static void writeStringArrayValues(JsonGenerator generator, String[] array, int count) throws IOException {
        int i;
        int arrayLen = array != null ? array.length : 0;
        for (i = 0; i < count && i < arrayLen; ++i) {
            if (array[i] != null) {
                generator.writeString(array[i]);
                continue;
            }
            generator.writeNull();
        }
        while (i < count) {
            generator.writeNull();
            ++i;
        }
    }

    public static void writeDecimalArray(JsonGenerator generator, BigDecimal[] array) throws IOException, JsonGenerationException {
        if (array != null && array.length > 0) {
            generator.writeStartArray((Object)array, array.length);
            for (int i = 0; i < array.length; ++i) {
                BigDecimal s = array[i];
                if (s != null) {
                    generator.writeNumber(array[i]);
                    continue;
                }
                generator.writeNull();
            }
            generator.writeEndArray();
        } else {
            generator.writeNull();
        }
    }

    public static void writeDecimalArrayValues(JsonGenerator generator, BigDecimal[] array, int count) throws IOException {
        int i;
        int arrayLen = array != null ? array.length : 0;
        for (i = 0; i < count && i < arrayLen; ++i) {
            if (array[i] != null) {
                generator.writeNumber(array[i]);
                continue;
            }
            generator.writeNull();
        }
        while (i < count) {
            generator.writeNull();
            ++i;
        }
    }

    public static void writeNumberField(JsonGenerator gen, String fieldName, Number value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Double) {
            gen.writeNumberField(fieldName, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            gen.writeNumberField(fieldName, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            gen.writeNumberField(fieldName, ((Long)value).longValue());
        } else if (value instanceof Integer) {
            gen.writeNumberField(fieldName, ((Integer)value).intValue());
        } else if (value instanceof Short) {
            gen.writeFieldName(fieldName);
            gen.writeNumber(((Short)value).shortValue());
        } else if (value instanceof BigInteger) {
            gen.writeFieldName(fieldName);
            gen.writeNumber((BigInteger)value);
        } else {
            BigDecimal d = NumberUtils.bigDecimalForNumber(value);
            if (d != null) {
                gen.writeNumberField(fieldName, d);
            }
        }
    }

    public static Instant iso8610Timestamp(String timestamp) {
        Instant ts = null;
        if (timestamp != null && !timestamp.isEmpty()) {
            try {
                ts = Instant.parse(timestamp);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return ts;
    }

    public static void writeIso8601Timestamp(JsonGenerator gen, String fieldName, Instant value) throws IOException {
        if (value == null) {
            return;
        }
        gen.writeStringField(fieldName, DateTimeFormatter.ISO_INSTANT.format(value));
    }

    public static void writeBitmaskValue(JsonGenerator gen, String fieldName, Set<? extends Bitmaskable> value) throws IOException {
        int v = Bitmaskable.bitmaskValue(value);
        if (v > 0) {
            gen.writeNumberField(fieldName, v);
        }
    }

    public static BigDecimal parseDecimal(JsonParser p) throws IOException, JsonProcessingException {
        JsonToken t = p.nextToken();
        if (t != null) {
            if (t.isNumeric()) {
                return p.getDecimalValue();
            }
            if (t == JsonToken.VALUE_STRING) {
                try {
                    return new BigDecimal(p.getValueAsString());
                }
                catch (ArithmeticException | NumberFormatException e) {
                    String msg = e.getMessage();
                    if (msg == null || msg.isEmpty()) {
                        msg = "Invalid number value: " + p.getValueAsString();
                    }
                    throw new InvalidFormatException(p, msg, (Object)p.getValueAsString(), BigDecimal.class);
                }
            }
        }
        return null;
    }

    public static BigDecimal[] parseDecimalArray(JsonParser p) throws IOException, JsonProcessingException {
        JsonToken t = p.nextToken();
        if (p.isExpectedStartArrayToken()) {
            ArrayList<BigDecimal> l = new ArrayList<BigDecimal>(8);
            do {
                BigDecimal n;
                if ((n = JsonUtils.parseDecimal(p)) != null) {
                    l.add(n);
                    continue;
                }
                t = p.currentToken();
                if (t == JsonToken.END_ARRAY) continue;
                l.add(null);
            } while (t != null && t != JsonToken.END_ARRAY);
            return l.toArray(new BigDecimal[l.size()]);
        }
        return null;
    }

    public static Map<String, ?> parseSimpleMap(JsonParser p) throws IOException, JsonProcessingException {
        JsonToken t = p.nextToken();
        LinkedHashMap<String, Object> result = null;
        if (p.isExpectedStartObjectToken()) {
            String f;
            result = new LinkedHashMap<String, Object>(8);
            while ((f = p.nextFieldName()) != null) {
                t = p.nextToken();
                Object v = null;
                if (t.isNumeric()) {
                    v = p.getNumberValue();
                } else if (t.isScalarValue()) {
                    v = p.getText();
                }
                if (v == null) continue;
                result.put(f, v);
            }
        }
        return result;
    }

    public static void writeSimpleMap(JsonGenerator generator, Map<String, ?> value) throws IOException, JsonGenerationException {
        assert (value != null);
        generator.writeStartObject(value, value.size());
        for (Map.Entry<String, ?> me : value.entrySet()) {
            String f = me.getKey();
            Object v = me.getValue();
            if (v == null) continue;
            if (v instanceof Long) {
                generator.writeNumberField(f, ((Long)v).longValue());
                continue;
            }
            if (v instanceof Integer) {
                generator.writeNumberField(f, ((Integer)v).intValue());
                continue;
            }
            if (v instanceof BigDecimal) {
                generator.writeNumberField(f, (BigDecimal)v);
                continue;
            }
            if (v instanceof BigInteger) {
                generator.writeFieldName(f);
                generator.writeNumber((BigInteger)v);
                continue;
            }
            if (v instanceof Half) {
                generator.writeNumberField(f, ((Half)v).floatValue());
                continue;
            }
            generator.writeStringField(f, v.toString());
        }
        generator.writeEndObject();
    }

    public static void parseIndexedFieldsObject(JsonParser p, DeserializationContext ctxt, Object[] data, Map<String, ? extends IndexedField> fields) throws IOException, JsonProcessingException {
        String f = null;
        int len = data.length;
        while ((f = p.nextFieldName()) != null) {
            Object o;
            int index;
            IndexedField field = fields.get(f);
            if (field == null || (index = field.getIndex()) >= len || (o = field.parseValue(p, ctxt)) == null) continue;
            data[index] = o;
        }
    }

    static {
        SimpleModule m2 = new SimpleModule("SolarNetwork Datum");
        m2.addSerializer(BasicGeneralDatumSerializer.INSTANCE);
        m2.addSerializer((JsonSerializer)BasicLocationSerializer.INSTANCE);
        m2.addSerializer((JsonSerializer)BasicObjectDatumStreamMetadataSerializer.INSTANCE);
        m2.addSerializer((JsonSerializer)BasicStreamDatumArraySerializer.INSTANCE);
        m2.addSerializer(BasicInstructionSerializer.INSTANCE);
        m2.addSerializer(BasicInstructionStatusSerializer.INSTANCE);
        m2.addSerializer(ObjectDatumStreamMetadataId.class, (JsonSerializer)BasicObjectDatumStreamMetadataIdSerializer.INSTANCE);
        m2.addSerializer((JsonSerializer)BasicObjectDatumStreamDataSetSerializer.INSTANCE);
        m2.addDeserializer(Datum.class, BasicGeneralDatumDeserializer.INSTANCE);
        m2.addDeserializer(Location.class, (JsonDeserializer)BasicLocationDeserializer.INSTANCE);
        m2.addDeserializer(ObjectDatumStreamMetadata.class, (JsonDeserializer)BasicObjectDatumStreamMetadataDeserializer.INSTANCE);
        m2.addDeserializer(StreamDatum.class, (JsonDeserializer)BasicStreamDatumArrayDeserializer.INSTANCE);
        m2.addDeserializer(Instruction.class, BasicInstructionDeserializer.INSTANCE);
        m2.addDeserializer(InstructionStatus.class, BasicInstructionStatusDeserializer.INSTANCE);
        m2.addDeserializer(ObjectDatumStreamMetadataId.class, (JsonDeserializer)BasicObjectDatumStreamMetadataIdDeserializer.INSTANCE);
        m2.addDeserializer(ObjectDatumStreamDataSet.class, (JsonDeserializer)BasicObjectDatumStreamDataSetDeserializer.INSTANCE);
        DATUM_MODULE = m2;
        OBJECT_MAPPER = JsonUtils.createObjectMapper();
    }

    private static final class StringMapTypeReference
    extends TypeReference<LinkedHashMap<String, Object>> {
    }
}

