/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collection;
import java.util.List;
import net.solarnetwork.codec.ObjectMapperModuleSupport;
import net.solarnetwork.codec.TypedKeyDeserializer;
import org.springframework.beans.factory.FactoryBean;

public class ObjectMapperFactoryBean
extends ObjectMapperModuleSupport
implements FactoryBean<ObjectMapper> {
    private JsonInclude.Include serializationInclusion = JsonInclude.Include.NON_NULL;
    private List<Object> featuresToEnable = null;
    private List<Object> featuresToDisable = null;

    public ObjectMapper getObject() throws Exception {
        ObjectMapper mapper = this.getObjectMapper();
        if (mapper == null) {
            mapper = new ObjectMapper();
            this.setObjectMapper(mapper);
        }
        SimpleModule module = new SimpleModule(this.getModuleName(), this.getModuleVersion());
        if (this.getSerializers() != null) {
            for (JsonSerializer<?> jsonSerializer : this.getSerializers()) {
                module.addSerializer(jsonSerializer);
            }
        }
        if (this.getDeserializers() != null) {
            for (JsonDeserializer jsonDeserializer : this.getDeserializers()) {
                this.registerDeserializer(module, jsonDeserializer);
            }
        }
        if (this.getKeyDeserializers() != null) {
            for (TypedKeyDeserializer typedKeyDeserializer : this.getKeyDeserializers()) {
                module.addKeyDeserializer(typedKeyDeserializer.getClass(), typedKeyDeserializer.getKeyDeserializer());
            }
        }
        if (this.getKeySerializers() != null) {
            for (JsonSerializer jsonSerializer : this.getKeySerializers()) {
                this.registerKeySerializer(module, jsonSerializer);
            }
        }
        if (this.serializationInclusion != null) {
            mapper.setSerializationInclusion(this.serializationInclusion);
        }
        this.setupFeatures(mapper, this.featuresToEnable, true);
        this.setupFeatures(mapper, this.featuresToDisable, false);
        mapper.registerModule((Module)module);
        List<Module> otherModules = this.getModules();
        if (otherModules != null) {
            this.getObjectMapper().registerModules(otherModules);
        }
        return mapper;
    }

    private void setupFeatures(ObjectMapper m, Collection<?> features, boolean state) {
        if (features == null) {
            return;
        }
        for (Object o : features) {
            if (o instanceof SerializationFeature) {
                m.configure((SerializationFeature)o, state);
                continue;
            }
            if (o instanceof DeserializationFeature) {
                m.configure((DeserializationFeature)o, state);
                continue;
            }
            if (!(o instanceof MapperFeature)) continue;
            m.configure((MapperFeature)o, state);
        }
    }

    public Class<?> getObjectType() {
        return ObjectMapper.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public JsonInclude.Include getSerializationInclusion() {
        return this.serializationInclusion;
    }

    public void setSerializationInclusion(JsonInclude.Include serializationInclusion) {
        this.serializationInclusion = serializationInclusion;
    }

    public List<Object> getFeaturesToEnable() {
        return this.featuresToEnable;
    }

    public void setFeaturesToEnable(List<Object> featuresToEnable) {
        this.featuresToEnable = featuresToEnable;
    }

    public List<Object> getFeaturesToDisable() {
        return this.featuresToDisable;
    }

    public void setFeaturesToDisable(List<Object> featuresToDisable) {
        this.featuresToDisable = featuresToDisable;
    }
}

