/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import java.util.Map;
import net.solarnetwork.codec.PropertySerializer;

public class PropertySerializerRegistrar {
    private Map<String, PropertySerializer> propertySerializers = null;
    private Map<String, PropertySerializer> classSerializers = null;

    public PropertySerializer serializerFor(String propertyName, Class<?> propertyType) {
        if (propertyName != null && this.propertySerializers != null && this.propertySerializers.containsKey(propertyName)) {
            return this.propertySerializers.get(propertyName);
        }
        if (propertyType != null && this.classSerializers != null && this.classSerializers.containsKey(propertyType.getName())) {
            return this.classSerializers.get(propertyType.getName());
        }
        return null;
    }

    public Object serializeProperty(String propertyName, Class<?> propertyType, Object bean, Object propertyValue) {
        PropertySerializer ser = this.serializerFor(propertyName, propertyType);
        if (ser == null) {
            return propertyValue;
        }
        return ser.serialize(bean, propertyName, propertyValue);
    }

    public Map<String, PropertySerializer> getPropertySerializers() {
        return this.propertySerializers;
    }

    public void setPropertySerializers(Map<String, PropertySerializer> propertySerializers) {
        this.propertySerializers = propertySerializers;
    }

    public Map<String, PropertySerializer> getClassSerializers() {
        return this.classSerializers;
    }

    public void setClassSerializers(Map<String, PropertySerializer> classSerializers) {
        this.classSerializers = classSerializers;
    }
}

