/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.dao;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.dao.PaginationCriteria;
import net.solarnetwork.domain.Identity;

@JsonPropertyOrder(value={"totalResults", "startingOffset", "returnedResultCount", "results"})
public class BasicFilterResults<M extends Identity<K>, K>
implements FilterResults<M, K> {
    private final Iterable<M> results;
    private final Long totalResults;
    private final int startingOffset;
    private final int returnedResultCount;

    public BasicFilterResults(Iterable<M> results, Long totalResults, int startingOffset, int returnedResultCount) {
        this.results = results;
        this.totalResults = totalResults;
        this.startingOffset = startingOffset;
        this.returnedResultCount = returnedResultCount;
    }

    public BasicFilterResults(Iterable<M> results) {
        this(results, null, 0, BasicFilterResults.iterableCount(results));
    }

    public static <M extends Identity<K>, K> FilterResults<M, K> filterResults(Iterable<M> data, PaginationCriteria criteria, Long totalResults, int returnedResults) {
        int offset = 0;
        if (criteria != null && criteria.getMax() != null) {
            offset = criteria.getOffset() != null ? criteria.getOffset() : 0;
        }
        return new BasicFilterResults<M, K>(data, totalResults, offset, returnedResults);
    }

    private static int iterableCount(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return (int)StreamSupport.stream(iterable.spliterator(), false).count();
    }

    @Override
    public Iterator<M> iterator() {
        if (this.results == null) {
            Set emptyResult = Collections.emptySet();
            return emptyResult.iterator();
        }
        return this.results.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicFilterResults{");
        if (this.totalResults != null) {
            builder.append("totalCount=");
            builder.append(this.totalResults);
            builder.append(", ");
        }
        builder.append("offset=");
        builder.append(this.startingOffset);
        builder.append(", count=");
        builder.append(this.returnedResultCount);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public Iterable<M> getResults() {
        return this.results;
    }

    @Override
    public Long getTotalResults() {
        return this.totalResults;
    }

    @Override
    public int getStartingOffset() {
        return this.startingOffset;
    }

    @Override
    public int getReturnedResultCount() {
        return this.returnedResultCount;
    }
}

