/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.dao;

import java.util.Map;

public interface BulkLoadingDao<T> {
    public LoadingContext<T> createBulkLoadingContext(LoadingOptions var1, LoadingExceptionHandler<T> var2);

    public static interface LoadingContext<T>
    extends AutoCloseable {
        public LoadingOptions getOptions();

        public void load(T var1);

        public long getLoadedCount();

        public long getCommittedCount();

        public T getLastLoadedEntity();

        public void createCheckpoint();

        public void commit();

        public void rollback();

        @Override
        public void close();
    }

    public static interface LoadingExceptionHandler<T> {
        public void handleLoadingException(Throwable var1, LoadingContext<T> var2);
    }

    public static interface LoadingOptions {
        public String getName();

        public Integer getBatchSize();

        public LoadingTransactionMode getTransactionMode();

        public Map<String, ?> getParameters();
    }

    public static enum LoadingTransactionMode {
        SingleTransaction,
        TransactionCheckpoints,
        BatchTransactions,
        NoTransaction;

    }
}

