/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.domain.SimpleSortDescriptor;
import net.solarnetwork.domain.SortDescriptor;

public interface GenericDao<T extends Entity<K>, K> {
    public static final List<SortDescriptor> SORT_BY_CREATED_ASCENDING = Collections.unmodifiableList(Collections.singletonList(new SimpleSortDescriptor(StandardSortKey.CREATED.toString())));
    public static final List<SortDescriptor> SORT_BY_CREATED_DESCENDING = Collections.unmodifiableList(Collections.singletonList(new SimpleSortDescriptor(StandardSortKey.CREATED.toString(), true)));
    public static final List<SortDescriptor> SORT_BY_ID_ASCENDING = Collections.unmodifiableList(Collections.singletonList(new SimpleSortDescriptor(StandardSortKey.ID.toString())));
    public static final List<SortDescriptor> SORT_BY_ID_DESCENDING = Collections.unmodifiableList(Collections.singletonList(new SimpleSortDescriptor(StandardSortKey.ID.toString(), true)));
    public static final List<SortDescriptor> SORT_BY_CREATED_ID_ASCENDING = Collections.unmodifiableList(Arrays.asList(new SimpleSortDescriptor(StandardSortKey.CREATED.toString()), new SimpleSortDescriptor(StandardSortKey.ID.toString())));
    public static final List<SortDescriptor> SORT_BY_CREATED_ID_DESCENDING = Collections.unmodifiableList(Arrays.asList(new SimpleSortDescriptor(StandardSortKey.CREATED.toString(), true), new SimpleSortDescriptor(StandardSortKey.ID.toString(), true)));
    public static final String ENTITY_EVENT_ENTITY_PROPERTY = "entity";
    public static final String ENTITY_EVENT_ENTITY_ID_PROPERTY = "id";
    public static final String ENTITY_EVENT_TOPIC_TEMPLATE = "net/solarnetwork/dao/%s/%s";

    public static String entityEventTopic(String entityName, String eventType) {
        return String.format(ENTITY_EVENT_TOPIC_TEMPLATE, entityName, eventType);
    }

    default public String entityEventTopic(EntityEventType eventType) {
        return GenericDao.entityEventTopic(this.getObjectType().getSimpleName(), eventType.name());
    }

    public static <E extends Entity<I>, I> Map<String, Object> createEntityEventProperties(I id, E entity) {
        if (id == null) {
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>(2);
        props.put(ENTITY_EVENT_ENTITY_ID_PROPERTY, id);
        if (entity != null) {
            props.put(ENTITY_EVENT_ENTITY_PROPERTY, entity);
        }
        return props;
    }

    public Class<? extends T> getObjectType();

    public K save(T var1);

    public T get(K var1);

    public Collection<T> getAll(List<SortDescriptor> var1);

    public void delete(T var1);

    public static enum EntityEventType {
        DELETED,
        STORED;

    }

    public static enum StandardSortKey {
        CREATED,
        ID;

    }
}

