/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.dao.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;

public class DataSourcePingTest
implements PingTest {
    private final DataSource dataSource;
    private final String query;
    private final String id;

    public DataSourcePingTest(DataSource dataSource, String query) {
        this.dataSource = dataSource;
        this.query = query;
        this.id = this.getClass().getName();
    }

    public DataSourcePingTest(DataSource dataSource, String query, String id) {
        this.dataSource = dataSource;
        this.query = query;
        this.id = id;
    }

    @Override
    public String getPingTestId() {
        return this.id;
    }

    @Override
    public String getPingTestName() {
        return "JDBC Pool DataSource Connection";
    }

    @Override
    public long getPingTestMaximumExecutionMilliseconds() {
        return 500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PingTest.Result performPingTest() throws Exception {
        if (this.dataSource == null) {
            return new PingTestResult(false, "No DataSource configured.");
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp ts = null;
        try {
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(this.query);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ts = rs.getTimestamp(1);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return new PingTestResult(ts != null, ts != null ? sdf.format(ts) : "No timestamp available.");
    }

    public String getQuery() {
        return this.query;
    }
}

