/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.dao.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import net.solarnetwork.dao.jdbc.SQLExceptionHandler;
import net.solarnetwork.service.OptionalServiceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLExceptionHandlerDataSourceProxy
implements DataSource,
ConnectionEventListener {
    private final DataSource delegate;
    private final OptionalServiceCollection<SQLExceptionHandler> handlers;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SQLExceptionHandlerDataSourceProxy(DataSource delegate, OptionalServiceCollection<SQLExceptionHandler> handlers) {
        this.delegate = delegate;
        this.handlers = handlers;
    }

    public DataSource getDelegate() {
        return this.delegate;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Connection conn = this.delegate.getConnection();
            return this.getWrappedConnection(conn);
        }
        catch (SQLException e) {
            this.handleSQLException(null, e);
            throw e;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Connection conn = this.delegate.getConnection(username, password);
            return this.getWrappedConnection(conn);
        }
        catch (SQLException e) {
            this.handleSQLException(null, e);
            throw e;
        }
    }

    private Connection getWrappedConnection(Connection conn) {
        if (conn instanceof PooledConnection) {
            PooledConnection pooledConn = (PooledConnection)((Object)conn);
            pooledConn.addConnectionEventListener(this);
        } else {
            conn = this.wrapJdbcObjectWithProxy(conn);
        }
        return conn;
    }

    private void collectAllInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        for (Class<?> i : clazz.getInterfaces()) {
            interfaces.add(i);
        }
        if (clazz.getSuperclass() != null) {
            this.collectAllInterfaces(clazz.getSuperclass(), interfaces);
        }
    }

    private <T> T wrapJdbcObjectWithProxy(T delegate) {
        LinkedHashSet allInterfaces = new LinkedHashSet();
        this.collectAllInterfaces(delegate.getClass(), allInterfaces);
        Class[] interfaces = allInterfaces.toArray(new Class[allInterfaces.size()]);
        Object proxy = Proxy.newProxyInstance(delegate.getClass().getClassLoader(), interfaces, (InvocationHandler)new JDBCDelegatingHandler(delegate));
        return (T)proxy;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        SQLException ex = event.getSQLException();
        try {
            this.handleSQLException((Connection)event.getSource(), ex);
        }
        catch (SQLException e) {
            this.log.warn("SQLException handling exception {}", (Object)ex, (Object)e);
        }
    }

    private void handleSQLException(final Connection conn, final SQLException e) throws SQLException {
        if (e == null) {
            return;
        }
        this.doWithHandlers(new SQLExceptionHandlerCallback(){

            @Override
            public void doWithHandler(SQLExceptionHandler handler) throws Exception {
                if (conn == null) {
                    handler.handleGetConnectionException(e);
                } else {
                    handler.handleConnectionException(conn, e);
                }
            }
        });
    }

    private void doWithHandlers(SQLExceptionHandlerCallback callback) throws SQLException {
        Iterable<SQLExceptionHandler> list = OptionalServiceCollection.services(this.handlers);
        if (list != null) {
            for (SQLExceptionHandler handler : list) {
                if (handler == null) continue;
                try {
                    callback.doWithHandler(handler);
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.log.error("SQLExceptionHandler threw exception", (Throwable)e);
                }
            }
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    private class JDBCDelegatingHandler
    implements InvocationHandler {
        private final Object delegate;

        public JDBCDelegatingHandler(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            try {
                Object res = delegateMethod.invoke(this.delegate, args);
                if (res instanceof Statement) {
                    res = SQLExceptionHandlerDataSourceProxy.this.wrapJdbcObjectWithProxy(res);
                }
                return res;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof SQLException) {
                    Connection conn = null;
                    if (this.delegate instanceof Connection) {
                        conn = (Connection)this.delegate;
                    } else if (this.delegate instanceof Statement) {
                        conn = ((Statement)this.delegate).getConnection();
                    }
                    SQLExceptionHandlerDataSourceProxy.this.handleSQLException(conn, (SQLException)t);
                }
                throw e.getCause();
            }
        }
    }

    static interface SQLExceptionHandlerCallback {
        public void doWithHandler(SQLExceptionHandler var1) throws Exception;
    }
}

