/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import net.solarnetwork.domain.Location;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BasicLocation
implements Location,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7249883372922528538L;
    private final String name;
    private final String country;
    private final String region;
    private final String stateOrProvince;
    private final String locality;
    private final String postalCode;
    private final String street;
    private final BigDecimal latitude;
    private final BigDecimal longitude;
    private final BigDecimal elevation;
    private final String timeZoneId;

    public BasicLocation(Location loc) {
        this(loc.getName(), loc.getCountry(), loc.getRegion(), loc.getStateOrProvince(), loc.getLocality(), loc.getPostalCode(), loc.getStreet(), loc.getLatitude(), loc.getLongitude(), loc.getElevation(), loc.getTimeZoneId());
    }

    public BasicLocation(String name, String country, String region, String stateOrProvince, String locality, String postalCode, String street, BigDecimal latitude, BigDecimal longitude, BigDecimal elevation, String timeZoneId) {
        this.name = name;
        this.country = country;
        this.region = region;
        this.stateOrProvince = stateOrProvince;
        this.locality = locality;
        this.postalCode = postalCode;
        this.street = street;
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
        this.timeZoneId = timeZoneId;
    }

    public static BasicLocation locationOf(String name, String country, String region, String stateOrProvince, String locality, String postalCode, String street, String timeZoneId) {
        return new BasicLocation(name, country, region, stateOrProvince, locality, postalCode, street, null, null, null, timeZoneId);
    }

    public static BasicLocation locationOf(String country, String region, String timeZoneId) {
        return new BasicLocation(null, country, region, null, null, null, null, null, null, null, timeZoneId);
    }

    public BasicLocation clone() {
        try {
            return (BasicLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.country, this.elevation, this.latitude, this.locality, this.longitude, this.name, this.postalCode, this.region, this.stateOrProvince, this.street, this.timeZoneId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (this.elevation != null && other.getElevation() != null ? this.elevation.compareTo(other.getElevation()) != 0 : !Objects.equals(this.elevation, other.getElevation())) {
            return false;
        }
        if (this.latitude != null && other.getLatitude() != null ? this.latitude.compareTo(other.getLatitude()) != 0 : !Objects.equals(this.latitude, other.getLatitude())) {
            return false;
        }
        if (this.longitude != null && other.getLongitude() != null ? this.longitude.compareTo(other.getLongitude()) != 0 : !Objects.equals(this.elevation, other.getLongitude())) {
            return false;
        }
        return Objects.equals(this.country, other.getCountry()) && Objects.equals(this.locality, other.getLocality()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.postalCode, other.getPostalCode()) && Objects.equals(this.region, other.getRegion()) && Objects.equals(this.stateOrProvince, other.getStateOrProvince()) && Objects.equals(this.street, other.getStreet()) && Objects.equals(this.timeZoneId, other.getTimeZoneId());
    }

    public static BasicLocation normalizedLocation(Location loc) {
        String timeZoneId;
        String street;
        String postalCode;
        String locality;
        String stateOrProvince;
        String region;
        String country;
        assert (loc != null);
        String name = loc.getName();
        if (name != null && (name = name.trim()).isEmpty()) {
            name = null;
        }
        if ((country = loc.getCountry()) != null) {
            country = (country = country.trim()).length() >= 2 ? country.substring(0, 2).toUpperCase() : null;
        }
        if ((region = loc.getRegion()) != null && (region = region.trim()).isEmpty()) {
            region = null;
        }
        if ((stateOrProvince = loc.getStateOrProvince()) != null && (stateOrProvince = stateOrProvince.trim()).isEmpty()) {
            stateOrProvince = null;
        }
        if ((locality = loc.getLocality()) != null && (locality = locality.trim()).isEmpty()) {
            locality = null;
        }
        if ((postalCode = loc.getPostalCode()) != null && (postalCode = postalCode.trim()).isEmpty()) {
            postalCode = null;
        }
        if ((street = loc.getStreet()) != null && (street = street.trim()).isEmpty()) {
            street = null;
        }
        if ((timeZoneId = loc.getTimeZoneId()) != null && (timeZoneId = timeZoneId.trim()).isEmpty()) {
            timeZoneId = null;
        }
        return new BasicLocation(name, country, region, stateOrProvince, locality, postalCode, street, loc.getLatitude(), loc.getLongitude(), loc.getElevation(), timeZoneId);
    }

    public static BasicLocation locationValue(Location location) {
        return location == null ? null : (location instanceof BasicLocation ? (BasicLocation)location : new BasicLocation(location));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicLocation{");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.country != null) {
            builder.append("country=");
            builder.append(this.country);
            builder.append(", ");
        }
        if (this.region != null) {
            builder.append("region=");
            builder.append(this.region);
            builder.append(", ");
        }
        if (this.locality != null) {
            builder.append("locality=");
            builder.append(this.locality);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    @Override
    public String getLocality() {
        return this.locality;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getStreet() {
        return this.street;
    }

    @Override
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    @Override
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    @Override
    public BigDecimal getElevation() {
        return this.elevation;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }
}

