/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.solarnetwork.domain.NetworkIdentity;

public class BasicNetworkIdentity
implements NetworkIdentity,
Serializable {
    private static final long serialVersionUID = 1734756599885882478L;
    private String identityKey;
    private String termsOfService;
    private String host;
    private Integer port;
    private boolean forceTLS;
    private Map<String, String> networkServiceURLs;

    public BasicNetworkIdentity() {
    }

    public BasicNetworkIdentity(String identityKey, String termsOfService, String host, Integer port, Boolean forceTLS) {
        this.setIdentityKey(identityKey);
        this.setTermsOfService(termsOfService);
        this.setHost(host);
        this.setPort(port);
        this.setForceTLS(forceTLS);
    }

    @Override
    public String getIdentityKey() {
        return this.identityKey;
    }

    @Override
    public String getTermsOfService() {
        return this.termsOfService;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public boolean isForceTLS() {
        return this.forceTLS;
    }

    public void setIdentityKey(String identityKey) {
        this.identityKey = identityKey;
    }

    public void setTermsOfService(String termsOfService) {
        this.termsOfService = termsOfService;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setForceTLS(boolean forceTLS) {
        this.forceTLS = forceTLS;
    }

    @Override
    public Map<String, String> getNetworkServiceURLs() {
        return this.networkServiceURLs;
    }

    public void setNetworkServiceURLs(Map<String, String> networkServiceURLs) {
        this.networkServiceURLs = networkServiceURLs;
    }

    private void putServiceURL(String key, String url) {
        if (key == null) {
            return;
        }
        if (url == null) {
            if (this.networkServiceURLs == null) {
                return;
            }
            this.networkServiceURLs.remove(key);
        } else {
            Map<String, String> map = this.networkServiceURLs;
            if (map == null) {
                this.networkServiceURLs = map = new LinkedHashMap<String, String>(2);
            }
            map.put(key, url);
        }
    }

    private String getServiceURL(String key) {
        return this.networkServiceURLs == null ? null : this.networkServiceURLs.get(key);
    }

    public void setSolarUserServiceURL(String url) {
        this.putServiceURL("solaruser", url);
    }

    public String getSolarUserServiceURL() {
        return this.getServiceURL("solaruser");
    }

    public void setSolarQueryServiceURL(String url) {
        this.putServiceURL("solarquery", url);
    }

    public String getSolarQueryServiceURL() {
        return this.getServiceURL("solarquery");
    }

    public void setSolarInMqttServiceURL(String url) {
        this.putServiceURL("solarin-mqtt", url);
    }

    public String getSolarInMqttServiceURL() {
        return this.getServiceURL("solarin-mqtt");
    }
}

