/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public interface Bitmaskable {
    public static final Comparator<Bitmaskable> SORT_BY_TYPE = new BitmaskableTypeSort();

    public int bitmaskBitOffset();

    public static int bitmaskValue(Set<? extends Bitmaskable> maskables) {
        int mask = 0;
        if (maskables != null) {
            for (Bitmaskable bitmaskable : maskables) {
                mask |= 1 << bitmaskable.bitmaskBitOffset();
            }
        }
        return mask;
    }

    public static <T extends Enum<T>> Set<T> setForBitmask(int mask, Class<T> clazz) {
        EnumSet result = Bitmaskable.setForBitmask((int)mask, (Bitmaskable[])((Enum[])clazz.getEnumConstants()));
        return result.isEmpty() ? result : EnumSet.copyOf(result);
    }

    public static <T extends Bitmaskable> Set<T> setForBitmask(int mask, T[] values) {
        if (mask < 1) {
            return Collections.emptySet();
        }
        HashSet<T> set = new HashSet<T>(16);
        for (T c : values) {
            int b = c.bitmaskBitOffset();
            if ((mask >> b & 1) != 1) continue;
            set.add(c);
        }
        return set.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public static final class BitmaskableTypeSort
    implements Comparator<Bitmaskable> {
        @Override
        public int compare(Bitmaskable o1, Bitmaskable o2) {
            int result = o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            if (result != 0) {
                return result;
            }
            return Integer.compare(o1.bitmaskBitOffset(), o2.bitmaskBitOffset());
        }
    }
}

