/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

public enum ByteOrdering {
    BigEndian('b', "Most to least significant"),
    LittleEndian('l', "Least to most signifiant");

    private char code;
    private String description;

    private ByteOrdering(char code, String description) {
        this.code = code;
        this.description = description;
    }

    public char getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ByteOrdering forCode(char code) {
        for (ByteOrdering e : ByteOrdering.values()) {
            if (code != e.code) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown ByteOrdering code [" + code + "]");
    }
}

