/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import net.solarnetwork.domain.Bitmaskable;

public enum DeviceOperatingState implements Bitmaskable
{
    Unknown(0),
    Normal(1),
    Starting(2),
    Standby(3),
    Shutdown(4),
    Fault(5),
    Disabled(6),
    Recovery(7),
    Override(8);

    private final int code;

    private DeviceOperatingState(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public int bitmaskBitOffset() {
        return this.code - 1;
    }

    public static DeviceOperatingState forCode(int code) {
        if (code == 0) {
            return null;
        }
        for (DeviceOperatingState c : DeviceOperatingState.values()) {
            if (code != c.code) continue;
            return c;
        }
        throw new IllegalArgumentException("DeviceOperatingState code [" + code + "] not supported");
    }
}

