/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.solarnetwork.domain.Bitmaskable;

public interface GroupedBitmaskable
extends Bitmaskable {
    public static final Comparator<GroupedBitmaskable> SORT_BY_OVERALL_INDEX = new SortByOverallIndex();

    public int getGroupIndex();

    public int getGroupSize();

    default public int getOverallIndex() {
        return this.getGroupIndex() * this.getGroupSize() + this.bitmaskBitOffset();
    }

    public static int groupBitmaskValue(Set<? extends GroupedBitmaskable> values, int group) {
        if (values == null || values.isEmpty()) {
            return 0;
        }
        HashSet<GroupedBitmaskable> set = new HashSet<GroupedBitmaskable>(16);
        for (GroupedBitmaskable groupedBitmaskable : values) {
            if (group != groupedBitmaskable.getGroupIndex()) continue;
            set.add(groupedBitmaskable);
        }
        if (set.isEmpty()) {
            return 0;
        }
        return Bitmaskable.bitmaskValue(set);
    }

    public static BitSet overallBitmaskValue(Set<? extends GroupedBitmaskable> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        BitSet set = new BitSet();
        for (GroupedBitmaskable groupedBitmaskable : values) {
            set.set(groupedBitmaskable.getOverallIndex());
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public static final class SortByOverallIndex
    implements Comparator<GroupedBitmaskable> {
        @Override
        public int compare(GroupedBitmaskable o1, GroupedBitmaskable o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int n1 = o1.getOverallIndex();
            int n2 = o2.getOverallIndex();
            return Integer.compare(n1, n2);
        }
    }
}

