/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Arrays;
import java.util.List;

@JsonPropertyOrder(value={"success", "code", "message", "errors", "data"})
public class Result<T> {
    private final Boolean success;
    private final String code;
    private final String message;
    private final List<ErrorDetail> errors;
    private final T data;

    public Result() {
        this(Boolean.TRUE, null, null, null);
    }

    public Result(T data) {
        this(Boolean.TRUE, null, null, data);
    }

    public Result(Boolean success, String code, String message, T data) {
        this(success, code, message, null, data);
    }

    public Result(Boolean success, String code, String message, List<ErrorDetail> errors, T data) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.errors = errors;
        this.data = data;
    }

    public static <V> Result<V> result(V data) {
        return Result.success(data);
    }

    public static <V> Result<V> success(V data) {
        return new Result<V>(Boolean.TRUE, null, null, null, data);
    }

    public static <V> Result<V> success() {
        return new Result<Object>(Boolean.TRUE, null, null, null, null);
    }

    public static <V> Result<V> error() {
        return new Result<Object>(Boolean.FALSE, null, null, null, null);
    }

    public static <V> Result<V> error(String message, List<ErrorDetail> errors) {
        return new Result<Object>(Boolean.FALSE, null, message, errors, null);
    }

    public static <V> Result<V> error(String code, String message, List<ErrorDetail> errors) {
        return new Result<Object>(Boolean.FALSE, code, message, errors, null);
    }

    public static <V> Result<V> error(String code, String message, ErrorDetail ... errors) {
        return new Result<Object>(Boolean.FALSE, code, message, errors != null && errors.length > 0 ? Arrays.asList(errors) : null, null);
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ErrorDetail> getErrors() {
        return this.errors;
    }

    public T getData() {
        return this.data;
    }

    @JsonPropertyOrder(value={"location", "code", "rejectedValue", "message"})
    public static class ErrorDetail {
        private final String location;
        private final String code;
        private final String rejectedValue;
        private final String message;

        public ErrorDetail(String location, String rejectedValue, String message) {
            this(location, null, rejectedValue, message);
        }

        public ErrorDetail(String location, String code, String rejectedValue, String message) {
            this.location = location;
            this.code = code;
            this.rejectedValue = rejectedValue;
            this.message = message;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCode() {
            return this.code;
        }

        public String getRejectedValue() {
            return this.rejectedValue;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

