/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.TimeZone;
import net.solarnetwork.domain.Location;

public class SimpleLocation
implements Location,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7734763057760648362L;
    private String name;
    private String country;
    private String region;
    private String stateOrProvince;
    private String locality;
    private String postalCode;
    private String street;
    private BigDecimal latitude;
    private BigDecimal longitude;
    private BigDecimal elevation;
    private String timeZoneId;

    public SimpleLocation() {
    }

    public SimpleLocation(Location loc) {
        this.setName(loc.getName());
        this.setCountry(loc.getCountry());
        this.setRegion(loc.getRegion());
        this.setStateOrProvince(loc.getStateOrProvince());
        this.setLocality(loc.getLocality());
        this.setPostalCode(loc.getPostalCode());
        this.setStreet(loc.getStreet());
        this.setLatitude(loc.getLatitude());
        this.setLongitude(loc.getLongitude());
        this.setElevation(loc.getElevation());
        this.setTimeZoneId(loc.getTimeZoneId());
    }

    public static SimpleLocation locationOf(String name, String country, String region, String stateOrProvince, String locality, String postalCode, String street, String timeZoneId) {
        SimpleLocation l = new SimpleLocation();
        l.setName(name);
        l.setCountry(country);
        l.setRegion(region);
        l.setStateOrProvince(stateOrProvince);
        l.setLocality(locality);
        l.setPostalCode(postalCode);
        l.setStreet(street);
        l.setTimeZoneId(timeZoneId);
        return l;
    }

    public static SimpleLocation locationOf(String country, String region, String timeZoneId) {
        SimpleLocation l = new SimpleLocation();
        l.setCountry(country);
        l.setRegion(region);
        l.setTimeZoneId(timeZoneId);
        return l;
    }

    public SimpleLocation clone() {
        try {
            return (SimpleLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.country, this.elevation, this.latitude, this.locality, this.longitude, this.name, this.postalCode, this.region, this.stateOrProvince, this.street, this.timeZoneId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (this.elevation != null && other.getElevation() != null ? this.elevation.compareTo(other.getElevation()) != 0 : !Objects.equals(this.elevation, other.getElevation())) {
            return false;
        }
        if (this.latitude != null && other.getLatitude() != null ? this.latitude.compareTo(other.getLatitude()) != 0 : !Objects.equals(this.latitude, other.getLatitude())) {
            return false;
        }
        if (this.longitude != null && other.getLongitude() != null ? this.longitude.compareTo(other.getLongitude()) != 0 : !Objects.equals(this.elevation, other.getLongitude())) {
            return false;
        }
        return Objects.equals(this.country, other.getCountry()) && Objects.equals(this.locality, other.getLocality()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.postalCode, other.getPostalCode()) && Objects.equals(this.region, other.getRegion()) && Objects.equals(this.stateOrProvince, other.getStateOrProvince()) && Objects.equals(this.street, other.getStreet()) && Objects.equals(this.timeZoneId, other.getTimeZoneId());
    }

    public void removeEmptyValues() {
        if (this.country != null && !SimpleLocation.hasText(this.country)) {
            this.country = null;
        }
        if (this.locality != null && !SimpleLocation.hasText(this.locality)) {
            this.locality = null;
        }
        if (this.name != null && !SimpleLocation.hasText(this.name)) {
            this.name = null;
        }
        if (this.postalCode != null && !SimpleLocation.hasText(this.postalCode)) {
            this.postalCode = null;
        }
        if (this.region != null && !SimpleLocation.hasText(this.region)) {
            this.region = null;
        }
        if (this.stateOrProvince != null && !SimpleLocation.hasText(this.stateOrProvince)) {
            this.stateOrProvince = null;
        }
        if (this.street != null && !SimpleLocation.hasText(this.street)) {
            this.street = null;
        }
        if (this.timeZoneId != null && !SimpleLocation.hasText(this.timeZoneId)) {
            this.timeZoneId = null;
        }
    }

    private static boolean hasText(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int strLen = s.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static SimpleLocation normalizedLocation(Location loc) {
        String street;
        String postalCode;
        String locality;
        String state;
        String region;
        TimeZone tz;
        String name;
        assert (loc != null);
        SimpleLocation norm = new SimpleLocation();
        if (loc.getName() != null && (name = loc.getName().trim()).length() > 0) {
            norm.setName(name);
        }
        if (loc.getCountry() != null && loc.getCountry().length() >= 2) {
            String country = loc.getCountry();
            if (country.length() > 2) {
                country = country.substring(0, 2);
            }
            norm.setCountry(country.toUpperCase());
        }
        if (loc.getTimeZoneId() != null && (tz = TimeZone.getTimeZone(loc.getTimeZoneId())) != null) {
            norm.setTimeZoneId(tz.getID());
        }
        if (loc.getRegion() != null && (region = loc.getRegion().trim()).length() > 0) {
            norm.setRegion(region);
        }
        if (loc.getStateOrProvince() != null && (state = loc.getStateOrProvince().trim()).length() > 0) {
            norm.setStateOrProvince(state);
        }
        if (loc.getLocality() != null && (locality = loc.getLocality().trim()).length() > 0) {
            norm.setLocality(locality);
        }
        if (loc.getPostalCode() != null && (postalCode = loc.getPostalCode().trim().toUpperCase()).length() > 0) {
            norm.setPostalCode(postalCode);
        }
        if (loc.getStreet() != null && (street = loc.getStreet().trim()).length() > 0) {
            norm.setStreet(street);
        }
        norm.setLatitude(loc.getLatitude());
        norm.setLongitude(loc.getLongitude());
        norm.setElevation(loc.getElevation());
        return norm;
    }

    public static SimpleLocation locationValue(Location location) {
        return location == null ? null : (location instanceof SimpleLocation ? (SimpleLocation)location : new SimpleLocation(location));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleLocation{");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.country != null) {
            builder.append("country=");
            builder.append(this.country);
            builder.append(", ");
        }
        if (this.region != null) {
            builder.append("region=");
            builder.append(this.region);
            builder.append(", ");
        }
        if (this.locality != null) {
            builder.append("locality=");
            builder.append(this.locality);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    @Override
    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Override
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    @Override
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    @Override
    public BigDecimal getElevation() {
        return this.elevation;
    }

    public void setElevation(BigDecimal elevation) {
        this.elevation = elevation;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }
}

