/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.domain.Bitmaskable;

public enum SkyCondition implements Bitmaskable
{
    Clear(1),
    ScatteredClouds(2),
    Cloudy(3),
    Fog(4),
    Drizzle(5),
    ScatteredShowers(6),
    Showers(7),
    Rain(8),
    Hail(9),
    ScatteredSnow(10),
    Snow(11),
    Storm(12),
    SevereStorm(13),
    Thunder(14),
    Windy(15),
    Hazy(16),
    Tornado(17),
    Hurricane(18),
    Dusty(19);

    private static final ConcurrentMap<Integer, Set<SkyCondition>> BITMASK_CACHE;
    private final int code;

    private SkyCondition(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public int bitmaskBitOffset() {
        return this.code - 1;
    }

    public static SkyCondition forCode(int code) {
        if (code == 0) {
            return null;
        }
        for (SkyCondition c : SkyCondition.values()) {
            if (code != c.code) continue;
            return c;
        }
        throw new IllegalArgumentException("SkyCondition code [" + code + "] not supported");
    }

    public static int bitmaskValue(Set<SkyCondition> conditions) {
        return Bitmaskable.bitmaskValue(conditions);
    }

    public static Set<SkyCondition> conditionsForBitmask(int mask) {
        return BITMASK_CACHE.computeIfAbsent(mask, m -> {
            Set<SkyCondition> set = Bitmaskable.setForBitmask((int)m, SkyCondition.class);
            return set.isEmpty() ? set : Collections.unmodifiableSet(EnumSet.copyOf(set));
        });
    }

    public static void clearBitmaskCache() {
        BITMASK_CACHE.clear();
    }

    static {
        BITMASK_CACHE = new ConcurrentHashMap<Integer, Set<SkyCondition>>(8, 0.9f, 1);
    }
}

