/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class AggregateDatumProperty {
    private final BigDecimal first;
    private int count = 1;
    private BigDecimal total;
    private BigDecimal min;
    private BigDecimal max;
    private BigDecimal last;

    public AggregateDatumProperty(BigDecimal val) {
        this.min = this.total = val == null ? BigDecimal.ZERO : val;
        this.max = this.total;
        this.first = this.total;
        this.last = this.total;
    }

    public void accumulate(BigDecimal val) {
        ++this.count;
        if (val == null) {
            val = BigDecimal.ZERO;
        }
        this.total = this.total.add(val);
        if (val.compareTo(this.min) < 0) {
            this.min = val;
        } else if (val.compareTo(this.max) > 0) {
            this.max = val;
        }
        this.last = val;
    }

    public BigDecimal average(int decimalScale) {
        return this.total.divide(new BigDecimal(this.count), decimalScale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public int getCount() {
        return this.count;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal first() {
        return this.first;
    }

    public BigDecimal last() {
        return this.last;
    }
}

