/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.domain.datum.AggregateStreamDatum;
import net.solarnetwork.domain.datum.BasicStreamDatum;
import net.solarnetwork.domain.datum.DatumProperties;
import net.solarnetwork.domain.datum.DatumPropertiesStatistics;

public class BasicAggregateStreamDatum
extends BasicStreamDatum
implements AggregateStreamDatum {
    private static final long serialVersionUID = 2501630135742744682L;
    private final Instant endTimestamp;
    private final DatumPropertiesStatistics statistics;

    public BasicAggregateStreamDatum(UUID streamId, Instant timestamp, DatumProperties properties, Instant endTimestamp, DatumPropertiesStatistics statistics) {
        super(streamId, timestamp, properties);
        this.endTimestamp = endTimestamp;
        this.statistics = statistics;
    }

    @Override
    public BasicAggregateStreamDatum clone() {
        return (BasicAggregateStreamDatum)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicAggregateStreamDatum{streamId=");
        builder.append(this.getStreamId());
        builder.append(", ts=");
        builder.append(this.getTimestamp());
        builder.append(", endTs=");
        builder.append(this.endTimestamp);
        DatumProperties properties = this.getProperties();
        if (properties != null) {
            if (properties.getInstantaneous() != null) {
                builder.append(", i=");
                builder.append(Arrays.toString(properties.getInstantaneous()));
            }
            if (properties.getAccumulating() != null) {
                builder.append(", a=");
                builder.append(Arrays.toString(properties.getAccumulating()));
            }
            if (properties.getStatus() != null) {
                builder.append(", s=");
                builder.append(Arrays.toString(properties.getStatus()));
            }
            if (properties.getTags() != null) {
                builder.append(", t=");
                builder.append(Arrays.toString(properties.getTags()));
            }
        }
        if (this.statistics != null) {
            if (this.statistics.getInstantaneous() != null) {
                builder.append(", si=");
                builder.append(Arrays.deepToString((Object[])this.statistics.getInstantaneous()));
            }
            if (this.statistics.getAccumulating() != null) {
                builder.append(", sa=");
                builder.append(Arrays.deepToString((Object[])this.statistics.getAccumulating()));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.endTimestamp, this.statistics);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BasicAggregateStreamDatum)) {
            return false;
        }
        BasicAggregateStreamDatum other = (BasicAggregateStreamDatum)obj;
        return Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.statistics, other.statistics);
    }

    @Override
    public Instant getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public DatumPropertiesStatistics getStatistics() {
        return this.statistics;
    }
}

