/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.domain.BasicLocation;
import net.solarnetwork.domain.Location;
import net.solarnetwork.domain.datum.BasicDatumStreamMetadata;
import net.solarnetwork.domain.datum.ObjectDatumKind;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;

public class BasicObjectDatumStreamMetadata
extends BasicDatumStreamMetadata
implements ObjectDatumStreamMetadata {
    private static final long serialVersionUID = -4093896601567626604L;
    private final ObjectDatumKind kind;
    private final Long objectId;
    private final String sourceId;
    private final BasicLocation location;
    private final String metaJson;

    public static BasicObjectDatumStreamMetadata emptyMeta(UUID streamId, String timeZoneId, ObjectDatumKind kind, Long objectId, String sourceId) {
        return new BasicObjectDatumStreamMetadata(streamId, timeZoneId, kind, objectId, sourceId, null, null, null, null);
    }

    public BasicObjectDatumStreamMetadata(UUID streamId, String timeZoneId, ObjectDatumKind kind, Long objectId, String sourceId, String[] instantaneousProperties, String[] accumulatingProperties, String[] statusProperties) {
        this(streamId, timeZoneId, kind, objectId, sourceId, null, instantaneousProperties, accumulatingProperties, statusProperties, null);
    }

    public BasicObjectDatumStreamMetadata(UUID streamId, String timeZoneId, ObjectDatumKind kind, Long objectId, String sourceId, String[] instantaneousProperties, String[] accumulatingProperties, String[] statusProperties, String metaJson) {
        this(streamId, timeZoneId, kind, objectId, sourceId, null, instantaneousProperties, accumulatingProperties, statusProperties, metaJson);
    }

    public BasicObjectDatumStreamMetadata(UUID streamId, String timeZoneId, ObjectDatumKind kind, Long objectId, String sourceId, Location location, String[] instantaneousProperties, String[] accumulatingProperties, String[] statusProperties, String metaJson) {
        super(streamId, timeZoneId, instantaneousProperties, accumulatingProperties, statusProperties);
        if (kind == null) {
            throw new IllegalArgumentException("The kind argument must not be null.");
        }
        this.kind = kind;
        if (objectId == null) {
            throw new IllegalArgumentException("The objectId argument must not be null.");
        }
        this.objectId = objectId;
        if (sourceId == null) {
            throw new IllegalArgumentException("The sourceId argument must not be null.");
        }
        this.sourceId = sourceId;
        this.location = BasicLocation.locationValue(location);
        this.metaJson = metaJson;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicObjectDatumStreamMetadata{");
        builder.append("streamId=");
        builder.append(this.getStreamId());
        builder.append(", kind=");
        builder.append((Object)this.kind);
        builder.append(", objectId=");
        builder.append(this.objectId);
        builder.append(", sourceId=");
        builder.append(this.sourceId);
        if (this.getPropertyNames() != null) {
            builder.append(", propertyNames=");
            builder.append(Arrays.toString(this.getPropertyNames()));
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.kind, this.location, this.metaJson, this.objectId, this.sourceId});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BasicObjectDatumStreamMetadata)) {
            return false;
        }
        BasicObjectDatumStreamMetadata other = (BasicObjectDatumStreamMetadata)obj;
        return this.kind == other.kind && Objects.equals(this.location, other.location) && Objects.equals(this.metaJson, other.metaJson) && Objects.equals(this.objectId, other.objectId) && Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public Long getObjectId() {
        return this.objectId;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public String getMetaJson() {
        return this.metaJson;
    }

    @Override
    public ObjectDatumKind getKind() {
        return this.kind;
    }

    @Override
    public BasicLocation getLocation() {
        return this.location;
    }
}

